% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_get_snapshots}
\alias{kendra_get_snapshots}
\title{Retrieves search metrics data}
\usage{
kendra_get_snapshots(
  IndexId,
  Interval,
  MetricType,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index to get search metrics data.}

\item{Interval}{[required] The time interval or time window to get search metrics data. The time
interval uses the time zone of your index. You can view data in the
following time windows:
\itemize{
\item \code{THIS_WEEK}: The current week, starting on the Sunday and ending on
the day before the current date.
\item \code{ONE_WEEK_AGO}: The previous week, starting on the Sunday and ending
on the following Saturday.
\item \code{TWO_WEEKS_AGO}: The week before the previous week, starting on the
Sunday and ending on the following Saturday.
\item \code{THIS_MONTH}: The current month, starting on the first day of the
month and ending on the day before the current date.
\item \code{ONE_MONTH_AGO}: The previous month, starting on the first day of
the month and ending on the last day of the month.
\item \code{TWO_MONTHS_AGO}: The month before the previous month, starting on
the first day of the month and ending on last day of the month.
}}

\item{MetricType}{[required] The metric you want to retrieve. You can specify only one metric per
call.

For more information about the metrics you can view, see \href{https://docs.aws.amazon.com/kendra/latest/dg/search-analytics.html}{Gaining insights with search analytics}.}

\item{NextToken}{If the previous response was incomplete (because there is more data to
retrieve), Amazon Kendra returns a pagination token in the response. You
can use this pagination token to retrieve the next set of search metrics
data.}

\item{MaxResults}{The maximum number of returned data for the metric.}
}
\description{
Retrieves search metrics data. The data provides a snapshot of how your users interact with your search application and how effective the application is.

See \url{https://www.paws-r-sdk.com/docs/kendra_get_snapshots/} for full documentation.
}
\keyword{internal}
