% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gluedatabrew_operations.R
\name{gluedatabrew_create_ruleset}
\alias{gluedatabrew_create_ruleset}
\title{Creates a new ruleset that can be used in a profile job to validate the
data quality of a dataset}
\usage{
gluedatabrew_create_ruleset(
  Name,
  Description = NULL,
  TargetArn,
  Rules,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the ruleset to be created. Valid characters are alphanumeric
(A-Z, a-z, 0-9), hyphen (-), period (.), and space.}

\item{Description}{The description of the ruleset.}

\item{TargetArn}{[required] The Amazon Resource Name (ARN) of a resource (dataset) that the ruleset
is associated with.}

\item{Rules}{[required] A list of rules that are defined with the ruleset. A rule includes one
or more checks to be validated on a DataBrew dataset.}

\item{Tags}{Metadata tags to apply to the ruleset.}
}
\description{
Creates a new ruleset that can be used in a profile job to validate the data quality of a dataset.

See \url{https://www.paws-r-sdk.com/docs/gluedatabrew_create_ruleset/} for full documentation.
}
\keyword{internal}
