% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_entity_records}
\alias{glue_get_entity_records}
\title{This API is used to query preview data from a given connection type or
from a native Amazon S3 based Glue Data Catalog}
\usage{
glue_get_entity_records(
  ConnectionName = NULL,
  CatalogId = NULL,
  EntityName,
  NextToken = NULL,
  DataStoreApiVersion = NULL,
  ConnectionOptions = NULL,
  FilterPredicate = NULL,
  Limit,
  OrderBy = NULL,
  SelectedFields = NULL
)
}
\arguments{
\item{ConnectionName}{The name of the connection that contains the connection type
credentials.}

\item{CatalogId}{The catalog ID of the catalog that contains the connection. This can be
null, By default, the Amazon Web Services Account ID is the catalog ID.}

\item{EntityName}{[required] Name of the entity that we want to query the preview data from the given
connection type.}

\item{NextToken}{A continuation token, included if this is a continuation call.}

\item{DataStoreApiVersion}{The API version of the SaaS connector.}

\item{ConnectionOptions}{Connector options that are required to query the data.}

\item{FilterPredicate}{A filter predicate that you can apply in the query request.}

\item{Limit}{[required] Limits the number of records fetched with the request.}

\item{OrderBy}{A parameter that orders the response preview data.}

\item{SelectedFields}{List of fields that we want to fetch as part of preview data.}
}
\description{
This API is used to query preview data from a given connection type or from a native Amazon S3 based Glue Data Catalog.

See \url{https://www.paws-r-sdk.com/docs/glue_get_entity_records/} for full documentation.
}
\keyword{internal}
