# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ivs_service.R
NULL

#' Performs GetChannel on multiple ARNs simultaneously
#'
#' @description
#' Performs [`get_channel`][ivs_get_channel] on multiple ARNs simultaneously.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_batch_get_channel/](https://www.paws-r-sdk.com/docs/ivs_batch_get_channel/) for full documentation.
#'
#' @param arns &#91;required&#93; Array of ARNs, one per channel.
#'
#' @keywords internal
#'
#' @rdname ivs_batch_get_channel
ivs_batch_get_channel <- function(arns) {
  op <- new_operation(
    name = "BatchGetChannel",
    http_method = "POST",
    http_path = "/BatchGetChannel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$batch_get_channel_input(arns = arns)
  output <- .ivs$batch_get_channel_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$batch_get_channel <- ivs_batch_get_channel

#' Performs GetStreamKey on multiple ARNs simultaneously
#'
#' @description
#' Performs [`get_stream_key`][ivs_get_stream_key] on multiple ARNs simultaneously.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_batch_get_stream_key/](https://www.paws-r-sdk.com/docs/ivs_batch_get_stream_key/) for full documentation.
#'
#' @param arns &#91;required&#93; Array of ARNs, one per stream key.
#'
#' @keywords internal
#'
#' @rdname ivs_batch_get_stream_key
ivs_batch_get_stream_key <- function(arns) {
  op <- new_operation(
    name = "BatchGetStreamKey",
    http_method = "POST",
    http_path = "/BatchGetStreamKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$batch_get_stream_key_input(arns = arns)
  output <- .ivs$batch_get_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$batch_get_stream_key <- ivs_batch_get_stream_key

#' Performs StartViewerSessionRevocation on multiple channel ARN and viewer
#' ID pairs simultaneously
#'
#' @description
#' Performs [`start_viewer_session_revocation`][ivs_start_viewer_session_revocation] on multiple channel ARN and viewer ID pairs simultaneously.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_batch_start_viewer_session_revocation/](https://www.paws-r-sdk.com/docs/ivs_batch_start_viewer_session_revocation/) for full documentation.
#'
#' @param viewerSessions &#91;required&#93; Array of viewer sessions, one per channel-ARN and viewer-ID pair.
#'
#' @keywords internal
#'
#' @rdname ivs_batch_start_viewer_session_revocation
ivs_batch_start_viewer_session_revocation <- function(viewerSessions) {
  op <- new_operation(
    name = "BatchStartViewerSessionRevocation",
    http_method = "POST",
    http_path = "/BatchStartViewerSessionRevocation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$batch_start_viewer_session_revocation_input(viewerSessions = viewerSessions)
  output <- .ivs$batch_start_viewer_session_revocation_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$batch_start_viewer_session_revocation <- ivs_batch_start_viewer_session_revocation

#' Creates a new channel and an associated stream key to start streaming
#'
#' @description
#' Creates a new channel and an associated stream key to start streaming.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_create_channel/](https://www.paws-r-sdk.com/docs/ivs_create_channel/) for full documentation.
#'
#' @param authorized Whether the channel is private (enabled for playback authorization).
#' Default: `false`.
#' @param containerFormat Indicates which content-packaging format is used (MPEG-TS or fMP4). If
#' `multitrackInputConfiguration` is specified and `enabled` is `true`,
#' then `containerFormat` is required and must be set to `FRAGMENTED_MP4`.
#' Otherwise, `containerFormat` may be set to `TS` or `FRAGMENTED_MP4`.
#' Default: `TS`.
#' @param insecureIngest Whether the channel allows insecure RTMP and SRT ingest. Default:
#' `false`.
#' @param latencyMode Channel latency mode. Use `NORMAL` to broadcast and deliver live video
#' up to Full HD. Use `LOW` for near-real-time interaction with viewers.
#' Default: `LOW`.
#' @param multitrackInputConfiguration Object specifying multitrack input configuration. Default: no multitrack
#' input configuration is specified.
#' @param name Channel name.
#' @param playbackRestrictionPolicyArn Playback-restriction-policy ARN. A valid ARN value here both specifies
#' the ARN and enables playback restriction. Default: "" (empty string, no
#' playback restriction policy is applied).
#' @param preset Optional transcode preset for the channel. This is selectable only for
#' `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types,
#' the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel
#' types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
#' @param recordingConfigurationArn Recording-configuration ARN. A valid ARN value here both specifies the
#' ARN and enables recording. Default: "" (empty string, recording is
#' disabled).
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`. See
#' [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#' @param type Channel type, which determines the allowable resolution and bitrate. *If
#' you exceed the allowable input resolution or bitrate, the stream
#' probably will disconnect immediately.* Default: `STANDARD`. For details,
#' see [Channel
#' Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
#'
#' @keywords internal
#'
#' @rdname ivs_create_channel
ivs_create_channel <- function(authorized = NULL, containerFormat = NULL, insecureIngest = NULL, latencyMode = NULL, multitrackInputConfiguration = NULL, name = NULL, playbackRestrictionPolicyArn = NULL, preset = NULL, recordingConfigurationArn = NULL, tags = NULL, type = NULL) {
  op <- new_operation(
    name = "CreateChannel",
    http_method = "POST",
    http_path = "/CreateChannel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$create_channel_input(authorized = authorized, containerFormat = containerFormat, insecureIngest = insecureIngest, latencyMode = latencyMode, multitrackInputConfiguration = multitrackInputConfiguration, name = name, playbackRestrictionPolicyArn = playbackRestrictionPolicyArn, preset = preset, recordingConfigurationArn = recordingConfigurationArn, tags = tags, type = type)
  output <- .ivs$create_channel_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_channel <- ivs_create_channel

#' Creates a new playback restriction policy, for constraining playback by
#' countries and/or origins
#'
#' @description
#' Creates a new playback restriction policy, for constraining playback by countries and/or origins.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_create_playback_restriction_policy/](https://www.paws-r-sdk.com/docs/ivs_create_playback_restriction_policy/) for full documentation.
#'
#' @param allowedCountries A list of country codes that control geoblocking restriction. Allowed
#' values are the officially assigned [ISO 3166-1
#' alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes.
#' Default: All countries (an empty array).
#' @param allowedOrigins A list of origin sites that control CORS restriction. Allowed values are
#' the same as valid values of the Origin header defined at
#' <https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin>.
#' Default: All origins (an empty array).
#' @param enableStrictOriginEnforcement Whether channel playback is constrained by origin site. Default:
#' `false`.
#' @param name Playback-restriction-policy name. The value does not need to be unique.
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`. See
#' [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#'
#' @keywords internal
#'
#' @rdname ivs_create_playback_restriction_policy
ivs_create_playback_restriction_policy <- function(allowedCountries = NULL, allowedOrigins = NULL, enableStrictOriginEnforcement = NULL, name = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreatePlaybackRestrictionPolicy",
    http_method = "POST",
    http_path = "/CreatePlaybackRestrictionPolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$create_playback_restriction_policy_input(allowedCountries = allowedCountries, allowedOrigins = allowedOrigins, enableStrictOriginEnforcement = enableStrictOriginEnforcement, name = name, tags = tags)
  output <- .ivs$create_playback_restriction_policy_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_playback_restriction_policy <- ivs_create_playback_restriction_policy

#' Creates a new recording configuration, used to enable recording to
#' Amazon S3
#'
#' @description
#' Creates a new recording configuration, used to enable recording to Amazon S3.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_create_recording_configuration/](https://www.paws-r-sdk.com/docs/ivs_create_recording_configuration/) for full documentation.
#'
#' @param destinationConfiguration &#91;required&#93; A complex type that contains a destination configuration for where
#' recorded video will be stored.
#' @param name Recording-configuration name. The value does not need to be unique.
#' @param recordingReconnectWindowSeconds If a broadcast disconnects and then reconnects within the specified
#' interval, the multiple streams will be considered a single broadcast and
#' merged together. Default: 0.
#' @param renditionConfiguration Object that describes which renditions should be recorded for a stream.
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`. See
#' [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#' @param thumbnailConfiguration A complex type that allows you to enable/disable the recording of
#' thumbnails for a live session and modify the interval at which
#' thumbnails are generated for the live session.
#'
#' @keywords internal
#'
#' @rdname ivs_create_recording_configuration
ivs_create_recording_configuration <- function(destinationConfiguration, name = NULL, recordingReconnectWindowSeconds = NULL, renditionConfiguration = NULL, tags = NULL, thumbnailConfiguration = NULL) {
  op <- new_operation(
    name = "CreateRecordingConfiguration",
    http_method = "POST",
    http_path = "/CreateRecordingConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$create_recording_configuration_input(destinationConfiguration = destinationConfiguration, name = name, recordingReconnectWindowSeconds = recordingReconnectWindowSeconds, renditionConfiguration = renditionConfiguration, tags = tags, thumbnailConfiguration = thumbnailConfiguration)
  output <- .ivs$create_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_recording_configuration <- ivs_create_recording_configuration

#' Creates a stream key, used to initiate a stream, for the specified
#' channel ARN
#'
#' @description
#' Creates a stream key, used to initiate a stream, for the specified channel ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_create_stream_key/](https://www.paws-r-sdk.com/docs/ivs_create_stream_key/) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel for which to create the stream key.
#' @param tags Array of 1-50 maps, each of the form `string:string (key:value)`. See
#' [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#'
#' @keywords internal
#'
#' @rdname ivs_create_stream_key
ivs_create_stream_key <- function(channelArn, tags = NULL) {
  op <- new_operation(
    name = "CreateStreamKey",
    http_method = "POST",
    http_path = "/CreateStreamKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$create_stream_key_input(channelArn = channelArn, tags = tags)
  output <- .ivs$create_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$create_stream_key <- ivs_create_stream_key

#' Deletes the specified channel and its associated stream keys
#'
#' @description
#' Deletes the specified channel and its associated stream keys.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_delete_channel/](https://www.paws-r-sdk.com/docs/ivs_delete_channel/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_channel
ivs_delete_channel <- function(arn) {
  op <- new_operation(
    name = "DeleteChannel",
    http_method = "POST",
    http_path = "/DeleteChannel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$delete_channel_input(arn = arn)
  output <- .ivs$delete_channel_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_channel <- ivs_delete_channel

#' Deletes a specified authorization key pair
#'
#' @description
#' Deletes a specified authorization key pair. This invalidates future viewer tokens generated using the key pair’s `privateKey`. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_delete_playback_key_pair/](https://www.paws-r-sdk.com/docs/ivs_delete_playback_key_pair/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the key pair to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_playback_key_pair
ivs_delete_playback_key_pair <- function(arn) {
  op <- new_operation(
    name = "DeletePlaybackKeyPair",
    http_method = "POST",
    http_path = "/DeletePlaybackKeyPair",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$delete_playback_key_pair_input(arn = arn)
  output <- .ivs$delete_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_playback_key_pair <- ivs_delete_playback_key_pair

#' Deletes the specified playback restriction policy
#'
#' @description
#' Deletes the specified playback restriction policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_delete_playback_restriction_policy/](https://www.paws-r-sdk.com/docs/ivs_delete_playback_restriction_policy/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the playback restriction policy to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_playback_restriction_policy
ivs_delete_playback_restriction_policy <- function(arn) {
  op <- new_operation(
    name = "DeletePlaybackRestrictionPolicy",
    http_method = "POST",
    http_path = "/DeletePlaybackRestrictionPolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$delete_playback_restriction_policy_input(arn = arn)
  output <- .ivs$delete_playback_restriction_policy_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_playback_restriction_policy <- ivs_delete_playback_restriction_policy

#' Deletes the recording configuration for the specified ARN
#'
#' @description
#' Deletes the recording configuration for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_delete_recording_configuration/](https://www.paws-r-sdk.com/docs/ivs_delete_recording_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the recording configuration to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_recording_configuration
ivs_delete_recording_configuration <- function(arn) {
  op <- new_operation(
    name = "DeleteRecordingConfiguration",
    http_method = "POST",
    http_path = "/DeleteRecordingConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$delete_recording_configuration_input(arn = arn)
  output <- .ivs$delete_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_recording_configuration <- ivs_delete_recording_configuration

#' Deletes the stream key for the specified ARN, so it can no longer be
#' used to stream
#'
#' @description
#' Deletes the stream key for the specified ARN, so it can no longer be used to stream.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_delete_stream_key/](https://www.paws-r-sdk.com/docs/ivs_delete_stream_key/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the stream key to be deleted.
#'
#' @keywords internal
#'
#' @rdname ivs_delete_stream_key
ivs_delete_stream_key <- function(arn) {
  op <- new_operation(
    name = "DeleteStreamKey",
    http_method = "POST",
    http_path = "/DeleteStreamKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$delete_stream_key_input(arn = arn)
  output <- .ivs$delete_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$delete_stream_key <- ivs_delete_stream_key

#' Gets the channel configuration for the specified channel ARN
#'
#' @description
#' Gets the channel configuration for the specified channel ARN. See also [`batch_get_channel`][ivs_batch_get_channel].
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_channel/](https://www.paws-r-sdk.com/docs/ivs_get_channel/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel for which the configuration is to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_channel
ivs_get_channel <- function(arn) {
  op <- new_operation(
    name = "GetChannel",
    http_method = "POST",
    http_path = "/GetChannel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_channel_input(arn = arn)
  output <- .ivs$get_channel_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_channel <- ivs_get_channel

#' Gets a specified playback authorization key pair and returns the arn and
#' fingerprint
#'
#' @description
#' Gets a specified playback authorization key pair and returns the `arn` and `fingerprint`. The `privateKey` held by the caller can be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_playback_key_pair/](https://www.paws-r-sdk.com/docs/ivs_get_playback_key_pair/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the key pair to be returned.
#'
#' @keywords internal
#'
#' @rdname ivs_get_playback_key_pair
ivs_get_playback_key_pair <- function(arn) {
  op <- new_operation(
    name = "GetPlaybackKeyPair",
    http_method = "POST",
    http_path = "/GetPlaybackKeyPair",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_playback_key_pair_input(arn = arn)
  output <- .ivs$get_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_playback_key_pair <- ivs_get_playback_key_pair

#' Gets the specified playback restriction policy
#'
#' @description
#' Gets the specified playback restriction policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_playback_restriction_policy/](https://www.paws-r-sdk.com/docs/ivs_get_playback_restriction_policy/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the playback restriction policy to be returned.
#'
#' @keywords internal
#'
#' @rdname ivs_get_playback_restriction_policy
ivs_get_playback_restriction_policy <- function(arn) {
  op <- new_operation(
    name = "GetPlaybackRestrictionPolicy",
    http_method = "POST",
    http_path = "/GetPlaybackRestrictionPolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_playback_restriction_policy_input(arn = arn)
  output <- .ivs$get_playback_restriction_policy_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_playback_restriction_policy <- ivs_get_playback_restriction_policy

#' Gets the recording configuration for the specified ARN
#'
#' @description
#' Gets the recording configuration for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_recording_configuration/](https://www.paws-r-sdk.com/docs/ivs_get_recording_configuration/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the recording configuration to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_recording_configuration
ivs_get_recording_configuration <- function(arn) {
  op <- new_operation(
    name = "GetRecordingConfiguration",
    http_method = "POST",
    http_path = "/GetRecordingConfiguration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_recording_configuration_input(arn = arn)
  output <- .ivs$get_recording_configuration_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_recording_configuration <- ivs_get_recording_configuration

#' Gets information about the active (live) stream on a specified channel
#'
#' @description
#' Gets information about the active (live) stream on a specified channel.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_stream/](https://www.paws-r-sdk.com/docs/ivs_get_stream/) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN for stream to be accessed.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream
ivs_get_stream <- function(channelArn) {
  op <- new_operation(
    name = "GetStream",
    http_method = "POST",
    http_path = "/GetStream",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_stream_input(channelArn = channelArn)
  output <- .ivs$get_stream_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream <- ivs_get_stream

#' Gets stream-key information for a specified ARN
#'
#' @description
#' Gets stream-key information for a specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_stream_key/](https://www.paws-r-sdk.com/docs/ivs_get_stream_key/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN for the stream key to be retrieved.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream_key
ivs_get_stream_key <- function(arn) {
  op <- new_operation(
    name = "GetStreamKey",
    http_method = "POST",
    http_path = "/GetStreamKey",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_stream_key_input(arn = arn)
  output <- .ivs$get_stream_key_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream_key <- ivs_get_stream_key

#' Gets metadata on a specified stream
#'
#' @description
#' Gets metadata on a specified stream.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_get_stream_session/](https://www.paws-r-sdk.com/docs/ivs_get_stream_session/) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel resource
#' @param streamId Unique identifier for a live or previously live stream in the specified
#' channel. If no `streamId` is provided, this returns the most recent
#' stream session for the channel, if it exists.
#'
#' @keywords internal
#'
#' @rdname ivs_get_stream_session
ivs_get_stream_session <- function(channelArn, streamId = NULL) {
  op <- new_operation(
    name = "GetStreamSession",
    http_method = "POST",
    http_path = "/GetStreamSession",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$get_stream_session_input(channelArn = channelArn, streamId = streamId)
  output <- .ivs$get_stream_session_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$get_stream_session <- ivs_get_stream_session

#' Imports the public portion of a new key pair and returns its arn and
#' fingerprint
#'
#' @description
#' Imports the public portion of a new key pair and returns its `arn` and `fingerprint`. The `privateKey` can then be used to generate viewer authorization tokens, to grant viewers access to private channels. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_import_playback_key_pair/](https://www.paws-r-sdk.com/docs/ivs_import_playback_key_pair/) for full documentation.
#'
#' @param name Playback-key-pair name. The value does not need to be unique.
#' @param publicKeyMaterial &#91;required&#93; The public portion of a customer-generated key pair.
#' @param tags Any tags provided with the request are added to the playback key pair
#' tags. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#'
#' @keywords internal
#'
#' @rdname ivs_import_playback_key_pair
ivs_import_playback_key_pair <- function(name = NULL, publicKeyMaterial, tags = NULL) {
  op <- new_operation(
    name = "ImportPlaybackKeyPair",
    http_method = "POST",
    http_path = "/ImportPlaybackKeyPair",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$import_playback_key_pair_input(name = name, publicKeyMaterial = publicKeyMaterial, tags = tags)
  output <- .ivs$import_playback_key_pair_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$import_playback_key_pair <- ivs_import_playback_key_pair

#' Gets summary information about all channels in your account, in the
#' Amazon Web Services region where the API request is processed
#'
#' @description
#' Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed. This list can be filtered to match a specified name or recording-configuration ARN. Filters are mutually exclusive and cannot be used together. If you try to use both filters, you will get an error (409 ConflictException).
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_channels/](https://www.paws-r-sdk.com/docs/ivs_list_channels/) for full documentation.
#'
#' @param filterByName Filters the channel list to match the specified name.
#' @param filterByPlaybackRestrictionPolicyArn Filters the channel list to match the specified policy.
#' @param filterByRecordingConfigurationArn Filters the channel list to match the specified recording-configuration
#' ARN.
#' @param maxResults Maximum number of channels to return. Default: 100.
#' @param nextToken The first channel to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_channels
ivs_list_channels <- function(filterByName = NULL, filterByPlaybackRestrictionPolicyArn = NULL, filterByRecordingConfigurationArn = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListChannels",
    http_method = "POST",
    http_path = "/ListChannels",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "channels"),
    stream_api = FALSE
  )
  input <- .ivs$list_channels_input(filterByName = filterByName, filterByPlaybackRestrictionPolicyArn = filterByPlaybackRestrictionPolicyArn, filterByRecordingConfigurationArn = filterByRecordingConfigurationArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_channels_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_channels <- ivs_list_channels

#' Gets summary information about playback key pairs
#'
#' @description
#' Gets summary information about playback key pairs. For more information, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html) in the *Amazon IVS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_playback_key_pairs/](https://www.paws-r-sdk.com/docs/ivs_list_playback_key_pairs/) for full documentation.
#'
#' @param maxResults Maximum number of key pairs to return. Default: your service quota or
#' 100, whichever is smaller.
#' @param nextToken The first key pair to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_playback_key_pairs
ivs_list_playback_key_pairs <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPlaybackKeyPairs",
    http_method = "POST",
    http_path = "/ListPlaybackKeyPairs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "keyPairs"),
    stream_api = FALSE
  )
  input <- .ivs$list_playback_key_pairs_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_playback_key_pairs_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_playback_key_pairs <- ivs_list_playback_key_pairs

#' Gets summary information about playback restriction policies
#'
#' @description
#' Gets summary information about playback restriction policies.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_playback_restriction_policies/](https://www.paws-r-sdk.com/docs/ivs_list_playback_restriction_policies/) for full documentation.
#'
#' @param maxResults Maximum number of policies to return. Default: 1.
#' @param nextToken The first policy to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_playback_restriction_policies
ivs_list_playback_restriction_policies <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPlaybackRestrictionPolicies",
    http_method = "POST",
    http_path = "/ListPlaybackRestrictionPolicies",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivs$list_playback_restriction_policies_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_playback_restriction_policies_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_playback_restriction_policies <- ivs_list_playback_restriction_policies

#' Gets summary information about all recording configurations in your
#' account, in the Amazon Web Services region where the API request is
#' processed
#'
#' @description
#' Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_recording_configurations/](https://www.paws-r-sdk.com/docs/ivs_list_recording_configurations/) for full documentation.
#'
#' @param maxResults Maximum number of recording configurations to return. Default: your
#' service quota or 100, whichever is smaller.
#' @param nextToken The first recording configuration to retrieve. This is used for
#' pagination; see the `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_recording_configurations
ivs_list_recording_configurations <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListRecordingConfigurations",
    http_method = "POST",
    http_path = "/ListRecordingConfigurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "recordingConfigurations"),
    stream_api = FALSE
  )
  input <- .ivs$list_recording_configurations_input(maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_recording_configurations_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_recording_configurations <- ivs_list_recording_configurations

#' Gets summary information about stream keys for the specified channel
#'
#' @description
#' Gets summary information about stream keys for the specified channel.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_stream_keys/](https://www.paws-r-sdk.com/docs/ivs_list_stream_keys/) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN used to filter the list.
#' @param maxResults Maximum number of streamKeys to return. Default: 1.
#' @param nextToken The first stream key to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_stream_keys
ivs_list_stream_keys <- function(channelArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreamKeys",
    http_method = "POST",
    http_path = "/ListStreamKeys",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "streamKeys"),
    stream_api = FALSE
  )
  input <- .ivs$list_stream_keys_input(channelArn = channelArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_stream_keys_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_stream_keys <- ivs_list_stream_keys

#' Gets a summary of current and previous streams for a specified channel
#' in your account, in the AWS region where the API request is processed
#'
#' @description
#' Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_stream_sessions/](https://www.paws-r-sdk.com/docs/ivs_list_stream_sessions/) for full documentation.
#'
#' @param channelArn &#91;required&#93; Channel ARN used to filter the list.
#' @param maxResults Maximum number of streams to return. Default: 100.
#' @param nextToken The first stream to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_stream_sessions
ivs_list_stream_sessions <- function(channelArn, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreamSessions",
    http_method = "POST",
    http_path = "/ListStreamSessions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults"),
    stream_api = FALSE
  )
  input <- .ivs$list_stream_sessions_input(channelArn = channelArn, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_stream_sessions_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_stream_sessions <- ivs_list_stream_sessions

#' Gets summary information about live streams in your account, in the
#' Amazon Web Services region where the API request is processed
#'
#' @description
#' Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_streams/](https://www.paws-r-sdk.com/docs/ivs_list_streams/) for full documentation.
#'
#' @param filterBy Filters the stream list to match the specified criterion.
#' @param maxResults Maximum number of streams to return. Default: 100.
#' @param nextToken The first stream to retrieve. This is used for pagination; see the
#' `nextToken` response field.
#'
#' @keywords internal
#'
#' @rdname ivs_list_streams
ivs_list_streams <- function(filterBy = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStreams",
    http_method = "POST",
    http_path = "/ListStreams",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "streams"),
    stream_api = FALSE
  )
  input <- .ivs$list_streams_input(filterBy = filterBy, maxResults = maxResults, nextToken = nextToken)
  output <- .ivs$list_streams_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_streams <- ivs_list_streams

#' Gets information about Amazon Web Services tags for the specified ARN
#'
#' @description
#' Gets information about Amazon Web Services tags for the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/ivs_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be retrieved. The ARN must be URL-encoded.
#'
#' @keywords internal
#'
#' @rdname ivs_list_tags_for_resource
ivs_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .ivs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$list_tags_for_resource <- ivs_list_tags_for_resource

#' Inserts metadata into the active stream of the specified channel
#'
#' @description
#' Inserts metadata into the active stream of the specified channel. At most 5 requests per second per channel are allowed, each with a maximum 1 KB payload. (If 5 TPS is not sufficient for your needs, we recommend batching your data into a single PutMetadata call.) At most 155 requests per second per account are allowed. Also see [Embedding Metadata within a Video Stream](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/metadata.html) in the *Amazon IVS User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_put_metadata/](https://www.paws-r-sdk.com/docs/ivs_put_metadata/) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel into which metadata is inserted. This channel must
#' have an active stream.
#' @param metadata &#91;required&#93; Metadata to insert into the stream. Maximum: 1 KB per request.
#'
#' @keywords internal
#'
#' @rdname ivs_put_metadata
ivs_put_metadata <- function(channelArn, metadata) {
  op <- new_operation(
    name = "PutMetadata",
    http_method = "POST",
    http_path = "/PutMetadata",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$put_metadata_input(channelArn = channelArn, metadata = metadata)
  output <- .ivs$put_metadata_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$put_metadata <- ivs_put_metadata

#' Starts the process of revoking the viewer session associated with a
#' specified channel ARN and viewer ID
#'
#' @description
#' Starts the process of revoking the viewer session associated with a specified channel ARN and viewer ID. Optionally, you can provide a version to revoke viewer sessions less than and including that version. For instructions on associating a viewer ID with a viewer session, see [Setting Up Private Channels](https://docs.aws.amazon.com/ivs/latest/LowLatencyUserGuide/private-channels.html).
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_start_viewer_session_revocation/](https://www.paws-r-sdk.com/docs/ivs_start_viewer_session_revocation/) for full documentation.
#'
#' @param channelArn &#91;required&#93; The ARN of the channel associated with the viewer session to revoke.
#' @param viewerId &#91;required&#93; The ID of the viewer associated with the viewer session to revoke. Do
#' not use this field for personally identifying, confidential, or
#' sensitive information.
#' @param viewerSessionVersionsLessThanOrEqualTo An optional filter on which versions of the viewer session to revoke.
#' All versions less than or equal to the specified version will be
#' revoked. Default: 0.
#'
#' @keywords internal
#'
#' @rdname ivs_start_viewer_session_revocation
ivs_start_viewer_session_revocation <- function(channelArn, viewerId, viewerSessionVersionsLessThanOrEqualTo = NULL) {
  op <- new_operation(
    name = "StartViewerSessionRevocation",
    http_method = "POST",
    http_path = "/StartViewerSessionRevocation",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$start_viewer_session_revocation_input(channelArn = channelArn, viewerId = viewerId, viewerSessionVersionsLessThanOrEqualTo = viewerSessionVersionsLessThanOrEqualTo)
  output <- .ivs$start_viewer_session_revocation_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$start_viewer_session_revocation <- ivs_start_viewer_session_revocation

#' Disconnects the incoming RTMPS stream for the specified channel
#'
#' @description
#' Disconnects the incoming RTMPS stream for the specified channel. Can be used in conjunction with [`delete_stream_key`][ivs_delete_stream_key] to prevent further streaming to a channel.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_stop_stream/](https://www.paws-r-sdk.com/docs/ivs_stop_stream/) for full documentation.
#'
#' @param channelArn &#91;required&#93; ARN of the channel for which the stream is to be stopped.
#'
#' @keywords internal
#'
#' @rdname ivs_stop_stream
ivs_stop_stream <- function(channelArn) {
  op <- new_operation(
    name = "StopStream",
    http_method = "POST",
    http_path = "/StopStream",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$stop_stream_input(channelArn = channelArn)
  output <- .ivs$stop_stream_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$stop_stream <- ivs_stop_stream

#' Adds or updates tags for the Amazon Web Services resource with the
#' specified ARN
#'
#' @description
#' Adds or updates tags for the Amazon Web Services resource with the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_tag_resource/](https://www.paws-r-sdk.com/docs/ivs_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be added or updated. The ARN
#' must be URL-encoded.
#' @param tags &#91;required&#93; Array of tags to be added or updated. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#'
#' @keywords internal
#'
#' @rdname ivs_tag_resource
ivs_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .ivs$tag_resource_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$tag_resource <- ivs_tag_resource

#' Removes tags from the resource with the specified ARN
#'
#' @description
#' Removes tags from the resource with the specified ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_untag_resource/](https://www.paws-r-sdk.com/docs/ivs_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be removed. The ARN must be
#' URL-encoded.
#' @param tagKeys &#91;required&#93; Array of tags to be removed. Array of maps, each of the form
#' `string:string (key:value)`. See [Best practices and
#' strategies](https://docs.aws.amazon.com/tag-editor/latest/userguide/best-practices-and-strats.html)
#' in *Tagging Amazon Web Services Resources and Tag Editor* for details,
#' including restrictions that apply to tags and "Tag naming limits and
#' requirements"; Amazon IVS has no service-specific constraints beyond
#' what is documented there.
#'
#' @keywords internal
#'
#' @rdname ivs_untag_resource
ivs_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .ivs$untag_resource_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$untag_resource <- ivs_untag_resource

#' Updates a channel's configuration
#'
#' @description
#' Updates a channel's configuration. Live channels cannot be updated. You must stop the ongoing stream, update the channel, and restart the stream for the changes to take effect.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_update_channel/](https://www.paws-r-sdk.com/docs/ivs_update_channel/) for full documentation.
#'
#' @param arn &#91;required&#93; ARN of the channel to be updated.
#' @param authorized Whether the channel is private (enabled for playback authorization).
#' @param containerFormat Indicates which content-packaging format is used (MPEG-TS or fMP4). If
#' `multitrackInputConfiguration` is specified and `enabled` is `true`,
#' then `containerFormat` is required and must be set to `FRAGMENTED_MP4`.
#' Otherwise, `containerFormat` may be set to `TS` or `FRAGMENTED_MP4`.
#' Default: `TS`.
#' @param insecureIngest Whether the channel allows insecure RTMP and SRT ingest. Default:
#' `false`.
#' @param latencyMode Channel latency mode. Use `NORMAL` to broadcast and deliver live video
#' up to Full HD. Use `LOW` for near-real-time interaction with viewers.
#' @param multitrackInputConfiguration Object specifying multitrack input configuration. Default: no multitrack
#' input configuration is specified.
#' @param name Channel name.
#' @param playbackRestrictionPolicyArn Playback-restriction-policy ARN. A valid ARN value here both specifies
#' the ARN and enables playback restriction. If this is set to an empty
#' string, playback restriction policy is disabled.
#' @param preset Optional transcode preset for the channel. This is selectable only for
#' `ADVANCED_HD` and `ADVANCED_SD` channel types. For those channel types,
#' the default `preset` is `HIGHER_BANDWIDTH_DELIVERY`. For other channel
#' types (`BASIC` and `STANDARD`), `preset` is the empty string (`""`).
#' @param recordingConfigurationArn Recording-configuration ARN. A valid ARN value here both specifies the
#' ARN and enables recording. If this is set to an empty string, recording
#' is disabled.
#' @param type Channel type, which determines the allowable resolution and bitrate. *If
#' you exceed the allowable input resolution or bitrate, the stream
#' probably will disconnect immediately.* Default: `STANDARD`. For details,
#' see [Channel
#' Types](https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html).
#'
#' @keywords internal
#'
#' @rdname ivs_update_channel
ivs_update_channel <- function(arn, authorized = NULL, containerFormat = NULL, insecureIngest = NULL, latencyMode = NULL, multitrackInputConfiguration = NULL, name = NULL, playbackRestrictionPolicyArn = NULL, preset = NULL, recordingConfigurationArn = NULL, type = NULL) {
  op <- new_operation(
    name = "UpdateChannel",
    http_method = "POST",
    http_path = "/UpdateChannel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$update_channel_input(arn = arn, authorized = authorized, containerFormat = containerFormat, insecureIngest = insecureIngest, latencyMode = latencyMode, multitrackInputConfiguration = multitrackInputConfiguration, name = name, playbackRestrictionPolicyArn = playbackRestrictionPolicyArn, preset = preset, recordingConfigurationArn = recordingConfigurationArn, type = type)
  output <- .ivs$update_channel_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$update_channel <- ivs_update_channel

#' Updates a specified playback restriction policy
#'
#' @description
#' Updates a specified playback restriction policy.
#'
#' See [https://www.paws-r-sdk.com/docs/ivs_update_playback_restriction_policy/](https://www.paws-r-sdk.com/docs/ivs_update_playback_restriction_policy/) for full documentation.
#'
#' @param allowedCountries A list of country codes that control geoblocking restriction. Allowed
#' values are the officially assigned [ISO 3166-1
#' alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) codes.
#' Default: All countries (an empty array).
#' @param allowedOrigins A list of origin sites that control CORS restriction. Allowed values are
#' the same as valid values of the Origin header defined at
#' <https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Origin>.
#' Default: All origins (an empty array).
#' @param arn &#91;required&#93; ARN of the playback-restriction-policy to be updated.
#' @param enableStrictOriginEnforcement Whether channel playback is constrained by origin site. Default:
#' `false`.
#' @param name Playback-restriction-policy name. The value does not need to be unique.
#'
#' @keywords internal
#'
#' @rdname ivs_update_playback_restriction_policy
ivs_update_playback_restriction_policy <- function(allowedCountries = NULL, allowedOrigins = NULL, arn, enableStrictOriginEnforcement = NULL, name = NULL) {
  op <- new_operation(
    name = "UpdatePlaybackRestrictionPolicy",
    http_method = "POST",
    http_path = "/UpdatePlaybackRestrictionPolicy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .ivs$update_playback_restriction_policy_input(allowedCountries = allowedCountries, allowedOrigins = allowedOrigins, arn = arn, enableStrictOriginEnforcement = enableStrictOriginEnforcement, name = name)
  output <- .ivs$update_playback_restriction_policy_output()
  config <- get_config()
  svc <- .ivs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ivs$operations$update_playback_restriction_policy <- ivs_update_playback_restriction_policy
