% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rspec.R
\name{plot.rspec}
\alias{plot.rspec}
\title{Plot spectra}
\usage{
\method{plot}{rspec}(
  x,
  select = NULL,
  type = c("overlay", "stack", "heatmap"),
  varying = NULL,
  n = 100,
  labels = FALSE,
  labels.stack = NULL,
  labels.cex = 1,
  wl.guide = TRUE,
  ...
)
}
\arguments{
\item{x}{(required) a data frame, possibly an object of class \code{rspec}, with a
column with wavelength data, named 'wl', and the remaining column
containing spectra to plot.}

\item{select}{specification of which spectra to plot. Can be a numeric vector
or factor (e.g., \code{sex == "male"})}

\item{type}{what type of plot should be drawn. Possibilities are:
\itemize{
\item \code{overlay} (default) for plotting multiple spectra in a single panel with
a common y-axis.
\item \code{stack} for plotting multiple spectra in a vertical arrangement.
\item \code{heatmap} for plotting reflectance values by wavelength and a third
variable (\code{varying}).
}}

\item{varying}{a numeric vector giving values for y-axis in
\code{type = "heatmap"}.}

\item{n}{number of bins with which to interpolate colors and \code{varying} for
the heatplot.}

\item{labels}{logical. Add labels identifying each spectrum to the outer plot
margin? Defaults to \code{FALSE}. Ignored when \code{type = 'heatmap'}.}

\item{labels.stack}{a vector of labels for spectra when \code{labels = TRUE}.
Defaults to the column names from spectral data. Note you will likely want
to adjust the plot margins to accommodate the text labels. See \code{?par()} for
guidance on setting margins.}

\item{labels.cex}{size of the text labels when \code{labels = TRUE}.}

\item{wl.guide}{logical determining whether visible light spectrum should be
added to the x-axis.}

\item{...}{additional arguments passed to \code{\link[=plot]{plot()}} (or \code{\link[=image]{image()}} for
\code{"heatmap"}).}
}
\description{
Plots reflectance spectra in different arrangements.
}
\examples{
# Load angle-resolved reflectance data for a green-winged teal
data(teal)

# Create an overlay plot (default)
plot(teal)

# Create an stacked spectral plot
plot(teal, type = "stack")

# Create a reflectance heatmap
plot(teal, type = "heatmap")

}
\seealso{
\code{\link[=spec2rgb]{spec2rgb()}}, \code{\link[=image]{image()}}, \code{\link[=plot]{plot()}}
}
\author{
Thomas White \email{thomas.white026@gmail.com}

Hugo Gruson \email{hugo.gruson+R@normalesup.org}

Chad Eliason \email{cme16@zips.uakron.edu}
}
