% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.R
\name{clean_patterns}
\alias{clean_patterns}
\title{Automatically recognize, clean and label the pixels of a dorsal pattern image traced from ImageJ}
\usage{
clean_patterns(data, kmeans = TRUE, seed = 123, outliers = TRUE)
}
\arguments{
\item{data}{a data.table or data.frame: an input data should have two columns \code{x} and \code{y} in that order, indicating the x-coordinates and the y-coordinates, respectively. The columns should be of type \code{"numeric"}.}

\item{kmeans}{logical, whether to use k-means clustering to eliminate a reference pixel, if any. Defaults to TRUE. See the details below.}

\item{seed}{a single value, interpreted as an integer with the default set to 123.}

\item{outliers}{logical, whether to eliminate potential outliers in the x-coordinate even after removing the 1cm reference line with k-means clustering. Defaults to TRUE.}
}
\value{
Returns a \code{data.table} object with the following three columns:
\describe{
   \item{\code{x}, \code{y}}{the xy-coordinate of a pixel; type \code{"numeric"}}
   \item{\code{loc}}{the location label of a pixel, one of LEFT, RIGHT, MID; type \code{"character"}}
}
}
\description{
The function \code{clean_patterns} implements a k-means clustering-based automatic cleaning of the continuous dorsal pattern of a female brown anole lizard
traced from the ImageJ software.
}
\details{
\code{clean_patterns} implements a k-means clustering-based automatic cleaning of the continuous dorsal pattern of a female brown anole lizard, \emph{Anolis sagrei},
traced from ImageJ, an open source image processing program
designed for scientific multidimensional images. The function efficiently
\itemize{
  \item eliminates the 1cm reference pixel and possible outliers in the x direction,
  \item randomly chooses a mid-dorsal axis if there exist more than one,
  \item chooses the largest x-coordinate if multiple x-coordinates are given per y-coordinate,
  \item manages left or right dorsal pattern that heavily crosses over the mid-dorsal axis by first removing the mid-dorsal axis and then regrouping left and right pattern,
  \item removes pixels through which left or right pattern crosses over since empirically it has little impact on the values of the extracted features, see \code{extract_features} function,
  \item handles left or right dorsal pattern broken with a gap
}
}
\examples{
# load the sample dorsal pattern image
data(anole)

# plot of the pattern shows it contains the reference pixel
plot(anole$x, anole$y)

# remove the reference pixel, possible outliers and ambiguities
cleaned <- clean_patterns(anole)

# check the plot again
plot(cleaned$x, cleaned$y)

}
\author{
Seong Hyun Hwang, Rachel Myoung Moon
}
