% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/context.R
\name{pathling_evaluate_fhirpath}
\alias{pathling_evaluate_fhirpath}
\title{Evaluate a FHIRPath expression against a single FHIR resource}
\usage{
pathling_evaluate_fhirpath(
  pc,
  resource_type,
  resource_json,
  fhirpath_expression,
  context_expression = NULL,
  variables = NULL
)
}
\arguments{
\item{pc}{The PathlingContext object.}

\item{resource_type}{A string containing the FHIR resource type code (e.g., "Patient",
"Observation").}

\item{resource_json}{A string containing the FHIR resource as JSON.}

\item{fhirpath_expression}{A FHIRPath expression to evaluate (e.g., "name.family",
"gender = 'male'").}

\item{context_expression}{An optional context expression string. If provided, the main
expression is evaluated once for each result of the context expression. Defaults to NULL.}

\item{variables}{An optional named list of variables available via \code{\%variable} syntax.
Defaults to NULL.}
}
\value{
A list with two elements:
  \describe{
    \item{\code{results}}{A list of lists, each containing \code{type} (character) and
      \code{value} (the materialised R value or NULL).}
    \item{\code{expectedReturnType}}{A character string indicating the inferred return type.}
  }
}
\description{
Evaluates a FHIRPath expression against a single FHIR resource provided as a JSON string and
returns materialised typed results. The resource is encoded into a one-row Spark Dataset
internally, and the existing FHIRPath engine is used to evaluate the expression.
}
\examples{
\dontrun{
pc <- pathling_connect()
patient_json <- '{"resourceType": "Patient", "id": "example", "gender": "male"}'
result <- pathling_evaluate_fhirpath(pc, "Patient", patient_json, "gender")
for (entry in result$results) {
  cat(entry$type, ": ", entry$value, "\n")
}
pathling_disconnect(pc)
}
}
\seealso{
Other context functions: 
\code{\link{pathling_fhirpath_to_column}()},
\code{\link{pathling_filter}()},
\code{\link{pathling_search_to_column}()},
\code{\link{pathling_with_column}()}
}
\concept{context functions}
