/*
 * Decompiled with CFR 0.152.
 */
package Network;

import ActiveSubnetworkSearchAlgorithms.ActiveSubnetworkSearch;
import ActiveSubnetworkSearchMisc.Subnetwork;
import Network.Network;
import Network.Node;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;

public class SubnetworkFinder {
    Network network = ActiveSubnetworkSearch.network;
    HashSet<Node> nodesOnSet;
    HashSet<Node> reached;

    public ArrayList<Subnetwork> findSubnetworksDFS(HashSet<Node> nodesOnSet) {
        this.nodesOnSet = nodesOnSet;
        ArrayList<Subnetwork> subnetworkList = new ArrayList<Subnetwork>();
        this.reached = new HashSet(2 * nodesOnSet.size());
        for (Node node : nodesOnSet) {
            if (this.reached.contains(node)) continue;
            ArrayList<Node> subnetworkNodeList = new ArrayList<Node>();
            this.search(node, subnetworkNodeList);
            subnetworkList.add(new Subnetwork(subnetworkNodeList));
        }
        return subnetworkList;
    }

    private void search(Node node, ArrayList<Node> subnetworkNodeList) {
        this.reached.add(node);
        subnetworkNodeList.add(node);
        HashSet<Node> neighborNodesSet = this.network.getNeighborSet(node);
        for (Node neighborNode : neighborNodesSet) {
            if (!this.nodesOnSet.contains(neighborNode) || this.reached.contains(neighborNode)) continue;
            this.search(neighborNode, subnetworkNodeList);
        }
    }

    public ArrayList<Subnetwork> findSubnetworksDFSNonRecursive(HashSet<Node> nodesOnSet) {
        ArrayList<Subnetwork> subnetworkList = new ArrayList<Subnetwork>();
        HashSet<Node> reached = new HashSet<Node>(2 * nodesOnSet.size());
        for (Node node : nodesOnSet) {
            if (reached.contains(node)) continue;
            ArrayList<Node> subnetworkNodeList = new ArrayList<Node>();
            LinkedList<Node> nodesToBeChecked = new LinkedList<Node>();
            nodesToBeChecked.add(node);
            while (!nodesToBeChecked.isEmpty()) {
                Node curNode = (Node)nodesToBeChecked.pop();
                if (reached.contains(curNode)) continue;
                reached.add(curNode);
                subnetworkNodeList.add(curNode);
                for (Node neighborNode : this.network.getNeighborSet(curNode)) {
                    if (!nodesOnSet.contains(neighborNode) || reached.contains(neighborNode)) continue;
                    nodesToBeChecked.push(neighborNode);
                }
            }
            subnetworkList.add(new Subnetwork(subnetworkNodeList));
        }
        return subnetworkList;
    }

    public ArrayList<Subnetwork> findSubnetworksBFS(HashSet<Node> nodesOnSet) {
        ArrayList<Subnetwork> subnetworkList = new ArrayList<Subnetwork>();
        HashSet<Node> reached = new HashSet<Node>(2 * nodesOnSet.size());
        for (Node node : nodesOnSet) {
            if (reached.contains(node)) continue;
            ArrayList<Node> subnetworkNodeList = new ArrayList<Node>();
            LinkedList<Node> nodesToBeChecked = new LinkedList<Node>();
            nodesToBeChecked.add(node);
            while (!nodesToBeChecked.isEmpty()) {
                Node curNode = (Node)nodesToBeChecked.pop();
                if (reached.contains(curNode)) continue;
                reached.add(curNode);
                subnetworkNodeList.add(curNode);
                for (Node neighborNode : this.network.getNeighborSet(curNode)) {
                    if (!nodesOnSet.contains(neighborNode) || reached.contains(neighborNode)) continue;
                    nodesToBeChecked.add(neighborNode);
                }
            }
            subnetworkList.add(new Subnetwork(subnetworkNodeList));
        }
        return subnetworkList;
    }
}

