% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unnest-pv-data.R
\name{unnest_pv_data}
\alias{unnest_pv_data}
\title{Unnest PatentsView data}
\usage{
unnest_pv_data(data, pk = lifecycle::deprecated())
}
\arguments{
\item{data}{The data returned by \code{\link{search_pv}}. This is the first
element of the three-element result object you got back from
\code{search_pv}. It should be a list of length 1, with one data frame
inside it. See examples.}

\item{pk}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}.
should be the unique identifier for the primary entity. For example, if you
used the patent endpoint in your call to \code{search_pv}, you could
specify \code{pk = "patent_id"}. \strong{This identifier has to have
been included in your \code{fields} vector when you called
\code{search_pv}}. You can use \code{\link{get_ok_pk}} to suggest a
potential primary key for your data.}
}
\value{
A list with multiple data frames, one for each entity/subentity.
Each data frame will have the \code{pk} column in it, so you can link the
tables together as needed.
}
\description{
This function converts a single data frame that has subentity-level list
columns in it into multiple data frames, one for each entity/subentity.
The multiple data frames can be merged together using the primary key
variable specified by the user (see the
\href{https://r4ds.had.co.nz/relational-data.html}{relational data} chapter
in "R for Data Science" for an in-depth introduction to joining tabular data).
}
\examples{
\dontrun{

fields <- c(
  "patent_id", "patent_title",
  "inventors.inventor_city", "inventors.inventor_country"
)
res <- search_pv(query = '{"_gte":{"patent_year":2015}}', fields = fields)
unnest_pv_data(data = res$data)
}

}
