% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pass.lme.R
\name{pass.lme.CLb.test}
\alias{pass.lme.CLb.test}
\title{Calculate Power or Sample Size required \cr
for Contrasts of linear combinations \cr
of fixed effect parameters \cr
in Linear Mixed Effect (LME) Model}
\usage{
pass.lme.CLb.test(thetas, C = NULL, d = NULL, alpha = 0.05,
  power = NULL, n = NULL)
}
\arguments{
\item{thetas}{list of theta (LB and VLb), can be different for each group \cr \cr}

\item{C}{Contrast of Matrix \cr \cr}

\item{d}{Value vector to be tested for all contrast \cr \cr}

\item{alpha}{significant level \cr \cr}

\item{power}{desired power for sample size calculation \cr \cr}

\item{n}{sample size for power calculation / \cr
or sample size ratio with power for sample size calculation
   (NULL for balanced design) \cr \cr}
}
\value{
solved.power  given sample size n, this gives the power for testing H0 \cr
  solved.n      given the desired power, this gives the sample size for H0 \cr
}
\description{
Interested parameters/linear combinations LB from more than one
independent populations can be aggregrate togeter by
appending mu vertically and Sigma/n diagonally \cr \cr
Consider Lb~N(MU,SIGMA) as the aggregrated estimates\cr
Any comparison of interested parameters can be formulated by
multiplying a contrast matrix C on LB and set \cr \cr
H0: C*LB=d for any vector of value d to be tested \cr \cr
We then have \cr \cr
      C*Lb~N(C*MU,C*SIGMA*C') \cr \cr
and \cr \cr
      (C*Lb-d)'*inv(C*SIGMA*C')*(C*Lb-d)~chisq(q,lambda) \cr \cr
where degree of freedom q=rank(C*SIGMA*C'), \cr
non-centrality parameter lambda=(C*LB-d)'*inv(C*SIGMA*C')*(C*LB-d) \cr \cr \cr
Power of the test H0 is given by 1-beta=P(chisq(q,lambda)>qchisq(1-alpha,lambda)) \cr
Required sample size for desired power can be obtained by bisection method.
}
\details{
\href{https://drive.google.com/open?id=1MQvzp9na-Zm9mFT5jC1I_3U0JHEFky_k}{Technical note}
}
\note{
License: GPL-3
}
\examples{
#Example 1 (test fixed effect coefficient 2=0) with power of 80\%
# for 1-level LME model, with covariates X, Z: (1,t), t=1,2,3
# for both fixed and random effects, with fixed effect coefficients B: (100,-0.5),
# random effect variance D: (2 1;1 2), residual variance R: 0.2
B <- matrix(c(100,-0.5),2,1)
D <- matrix(c(2,1,1,2),2,2)
R <- 0.2
X <- cbind(rep(1,3),1:3)
Z <- X
theta <- lme.Lb.dist.theta(B,D,R,X,Z)
pass.lme.CLb.test(list(theta),alpha=0.05,power=0.8)
pass.lme.CLb.test(list(theta),alpha=0.05,n=66)

#Example 2 (compare two fixed effect coefficient 2) with power of 80\%
# Consider above model as a control group model,
# with an independent treatment group with model same as the control
# except a different fixed effect coefficient 2 for treatment
# = fixed effect coefficient 2 for control x 0.7
theta2 <- theta
theta2$mu <- theta$mu *0.7
C <- matrix(c(1,-1),1,2)
pass.lme.CLb.test(list(theta,theta2),C,alpha=0.05,power=0.8)
pass.lme.CLb.test(list(theta,theta2),C,alpha=0.05,n=1468)

#Example 3 (compare two fixed effect coefficient 2) with power of 80\%
# with sample size ratio, control:treatment = 1:2
pass.lme.CLb.test(list(theta,theta2),C,alpha=0.05,power=0.8,n=c(1,2))
pass.lme.CLb.test(list(theta,theta2),C,alpha=0.05,n=c(1101,2202))

#Example 4 (repeated-measures ANOVA for comparing 3 group means) with power of 80\%
# for 1-level LME model with mean for group 1, 2 and 3 are 100, 99, 102, respectively,
# each subject to be measured 2 times, with within-subject variance = 15, residual variance = 10
B <- 100
D <- 15
R <- 10
X <- matrix(1,2,1)
Z <- X
theta <- lme.Lb.dist.theta(B,D,R,X,Z)
theta2 <- theta
theta3 <- theta
theta2$mu <- 99
theta3$mu <- 102
C <- rbind(c(1,-1,0),c(1,0,-1))
pass.lme.CLb.test(list(theta,theta2,theta3),C,alpha=0.05,power=0.8)
pass.lme.CLb.test(list(theta,theta2,theta3),C,alpha=0.05,n=41)
}
\seealso{
\code{\link{lme.Lb.dist.theta}}
}
\author{
Marco Chak Yan YU \cr
Maintainer: Marco Chak Yan YU <marcocyyu@gmail.com>
}
