% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partyfacts.R
\name{get_party_logo_by_name}
\alias{get_party_logo_by_name}
\title{Get party logo by name}
\usage{
get_party_logo_by_name(party_name, country = NULL, data = NULL)
}
\arguments{
\item{party_name}{A character string with the party name to search for.}

\item{country}{Optional. ISO 3-letter country code to filter results.}

\item{data}{Optional. A Partyfacts dataset.}
}
\value{
If exactly one party is found, returns the logo URL. If multiple
  parties match, returns a tibble with party info and logo URLs. Returns NA
  if no party is found.
}
\description{
A convenience function that combines party lookup and logo extraction.
Searches for a party by name, finds its Wikipedia URL, and extracts the
party logo URL.
}
\examples{
\donttest{
if (curl::has_internet()) {
  # Get logo for German SPD
  get_party_logo_by_name("SPD", country = "DEU")

  # Search more broadly
  get_party_logo_by_name("Labour", country = "GBR")
}
}
}
