% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation.R
\name{map_partition}
\alias{map_partition}
\title{Map a partition across a range of minimum information}
\usage{
map_partition(
  .data,
  partitioner = part_icc(),
  ...,
  information = seq(0.1, 0.5, by = 0.1)
)
}
\arguments{
\item{.data}{a data set to partition}

\item{partitioner}{the partitioner to use. The default is \code{\link[=part_icc]{part_icc()}}.}

\item{...}{arguments passed to \code{\link[=partition]{partition()}}}

\item{information}{a vector of minimum information to fit in \code{\link[=partition]{partition()}}}
}
\value{
a tibble
}
\description{
\code{map_partition()} fits \code{partition()} across a range of minimum information
values, specified in the \code{information} argument. The output is a tibble with
a row for each value of \code{information}, a summary of the partition, and a
\code{list-col} containing the \code{partition} object.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)

map_partition(df, partitioner = part_pc1())

}
