% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partitioning_functions.R
\name{sample_to_population_partition}
\alias{sample_to_population_partition}
\title{Calculate population-level partition}
\usage{
sample_to_population_partition(DRY, M, N = length(M), Q,
  smallQ_correction = TRUE, uncorrected_cov = FALSE, nboot = NA)
}
\arguments{
\item{DRY}{change in relative yield, as calculated by the calculate_DRY function}

\item{M}{monoculture biomass}

\item{N}{number of species in the sample of the full community (i.e. the "sample") - defaults to length(M)}

\item{Q}{total number of species in the full community (i.e. the "population")}

\item{smallQ_correction}{tells whether to apply the correction for small Q, as shown in Eq. 3c in the main text - defaults to TRUE}

\item{uncorrected_cov}{A character, which can be TRUE, FALSE, or COMP. Tells whether to use the standard sample-size corrected covariance function (FALSE), or}

\item{nboot}{Number of bootstrap iterations to run for estimating confidence intervals for selection and complementarity effects. Defaults to NA - i.e. no bootstrapping.
a covariance function that is not corrected for sample size (TRUE), or
a "compromise" function that resembles the standard function for N < Q, and that resembles the non-corrected function for N ~ Q
If TRUE, then SS + CS = YO - YE, sensu Loreau and Hector 2001
defaults to FALSE
note - we do not recommend setting this to TRUE or "COMP", unless you require SS+CS=YO-YE}
}
\value{
a list with elements SS (the sample-level selection effect), CS (the sample-level complementarity effect),
SP (the population-level selection effect), CP (the population-level complementarity effect),
and confint, which is a list that includes summary data and the full bootstrapped for estimates of the confidence intervals (if nboot != NA)
}
\description{
takes a random but incomplete sample of species of size N from a larger community Q,
and estiamtes population-level selection and complementarity effects
}
\examples{
# Please see package help file (?partitionBEFsp) for examples.
}
