% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers_basic.R
\name{\%xthen\%}
\alias{\%xthen\%}
\alias{\%thenx\%}
\title{Keeping only first or second result from a \verb{\%then\%} sequence}
\usage{
p1 \%xthen\% p2

p1 \%thenx\% p2
}
\arguments{
\item{p1, p2}{two parsers.}
}
\value{
A parser.
}
\description{
Two parsers composed in sequence produce a pair of results. Sometimes we are
only interested in one component of the pair. For example in the case of
reserved words such as 'begin' and 'end'. In such cases, two special
versions of the \verb{\%then\%} combinator are useful, which keep either the
first or second result, as reflected by the position of the letter 'x' in
their names.
}
\section{Pseudocode}{


\preformatted{
(p1 \%xthen\% p2)(x):
  if p1(x)==[] or x==null then fail()(x)
  else
    if p2(x[-1])==[] then fail()(x)
    else succeed(p1(x)$L)(x[-2])

(p1 \%thenx\% p2)(x):
  if p1(x)==[] or x==null then fail()(x)
  else
    if p2(x[-1])==[] then fail()(x)
    else succeed(p2(x[-1])$L)(x[-2])
}
where \code{null} is the empty vector, \code{x[-1]} and \code{x[-2]} are the vector \code{x}
without the first element and without the first two elements, respectively.
}

\examples{
is_number <- function(x) grepl("\\\\d+", x[1])
# Numbers are preceded by ">" symbols, but we only want the number
(literal(">") \%thenx\% satisfy(is_number))(c(">", "12"))
# Temperatures are followed by the unit 'C', but we only want the number
(satisfy(is_number) \%xthen\% literal("C"))(c("21", "C"))

}
\seealso{
\link{\%then\%}
}
