% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dominant1}
\alias{dominant1}
\title{Dominant linkage analysis example}
\format{
A list with 3 elements:
\itemize{
\item \code{ped}: A \link[pedtools:ped]{pedtools::ped} object describing a pedigree with 19 individuals,
including genotypes for 14 members at 248 markers on Chromosome 1.
\item \code{aff}: A vector indicating the affected pedigree members.
\item \code{map}: A data frame with 3 columns (\code{chrom}, \code{marker}, \code{cm}) describing the
centiMorgan positions of the markers.
}
}
\usage{
dominant1
}
\description{
A dataset with SNP genotypes for 14 members of a pedigree affected with a
dominant disorder.
}
\examples{

data(dominant1)
ped = dominant1$ped
aff = dominant1$aff
model = diseaseModel("AD")

# Compute singlepoint LODs
lods = lod(ped, aff = aff, model = model)

# LOD score graph
plot(lods)


}
\keyword{datasets}
