% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setCategoriesRep}
\alias{setCategoriesRep}
\title{Categories Representation}
\usage{
setCategoriesRep(id, categoriesRep)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{categoriesRep}{One of the available category representations
(\code{EquallySpacedLines}, \code{EquallySizedBoxes}).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Within a category column, the height assigned to each category can either be:
\itemize{
\item equal for each category (\code{EquallySizedBoxes});
\item or calculated to reflect the proportion of lines
passing through each category (\code{EquallySpacedLines}).
}
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
     selectInput(
       "categoriesRepSelect",
       "Categories Representation:",
       choices = list(
         "EquallySpacedLines" = "EquallySpacedLines",
         "EquallySizedBoxes" = "EquallySizedBoxes"
       ),
       selected = "EquallySpacedLines"
     ),
     p("The selector controls the height assigned to each category"),
     parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
     output$parPlot <- renderParallelPlot({
       categorical <-
         list(cyl = c(4, 6, 8), vs = c(0, 1), am = c(0, 1), gear = 3:5, carb = 1:8)
       parallelPlot(mtcars, categorical = categorical, refColumnDim = "cyl")
     })
     observeEvent(input$categoriesRepSelect, {
       parallelPlot::setCategoriesRep("parPlot", input$categoriesRepSelect)
     })
   }

   shinyApp(ui, server)
 }

}
