% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Condition.R
\name{condition_test}
\alias{condition_test}
\alias{condition_as_string}
\alias{Condition}
\alias{CondEqual}
\alias{CondAnyOf}
\title{Dependency Condition}
\usage{
condition_test(cond, x)

condition_as_string(cond, lhs_chr = "x")

Condition(rhs, condition_format_string)
}
\arguments{
\item{cond}{(\code{Condition})\cr
\code{Condition} to use}

\item{x}{(\code{any})\cr
Value to test}

\item{lhs_chr}{(\code{character(1)})\cr
Symbolic representation to use for \verb{<lhs>} in the returned string.}

\item{rhs}{(\code{any})\cr
Right-hand-side of the condition.}

\item{condition_format_string}{(\code{character(1)})\cr
Format-string for representing the condition when pretty-printing
in \code{\link[=condition_as_string]{condition_as_string()}}.
Should contain two \verb{\%s}, as it is used in an \code{sprintf()}-call with
two further string values.}
}
\description{
Condition object, to specify the condition in a dependency.
}
\section{Functions}{
\itemize{
\item \code{condition_test()}: Used internally. Tests whether a value satisfies a given condition.
Vectorizes when \code{x} is atomic.

\item \code{condition_as_string()}: Used internally. Returns a string that represents the condition for pretty
printing, in the form \code{"<lhs> <relation> <rhs>"}, e.g. \code{"x == 3"} or
\code{"param \%in\% {1, 2, 10}"}.

}}
\section{Currently implemented simple conditions}{

\itemize{
\item \code{CondEqual(rhs)} \cr
Value must be equal to \code{rhs}.
\item \code{CondAnyOf(rhs)} \cr
Value must be any value of \code{rhs}.
}
}

