% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exception.R
\name{Exception}
\alias{Exception}
\title{Package Exceptions}
\format{
\describe{
\item{\code{Exception$abstract_class_not_instantiable(object)}}{Exception for instantiating abstract classes or interfaces.}
\item{\code{Exception$method_not_implemented()}}{Exception for calling methods without an implementation.}
\item{\code{Exception$feature_not_developed()}}{Exception for running into things not yet developed.}
\item{\code{Exception$not_enough_cores()}}{Exception for requesting more cores than available on the machine.}
\item{\code{Exception$cluster_active()}}{Exception for attempting to start a cluster while another one is active.}
\item{\code{Exception$cluster_not_active()}}{Exception for attempting to stop a cluster while not active.}
\item{\code{Exception$async_task_not_started()}}{Exception for reading results while an asynchronous task has not yet started.}
\item{\code{Exception$async_task_running()}}{Exception for reading results while an asynchronous task is running.}
\item{\code{Exception$async_task_completed()}}{Exception for reading results while a completed asynchronous task has unread results.}
\item{\code{Exception$async_task_error(error)}}{Exception for errors while running an asynchronous task.}
\item{\code{Exception$stop_busy_backend_not_allowed()}}{Exception for stopping a busy backend without intent.}
\item{\code{Exception$temporary_file_creation_failed()}}{Exception for reading results while an asynchronous task is running.}
\item{\code{Exception$type_not_assignable(actual, expected)}}{Exception for when providing incorrect object types.}
\item{\code{Exception$unknown_package_option(option)}}{Exception for when requesting unknown package options.}
\item{\code{Exception$primitive_as_task_not_allowed()}}{Exception for when decorating primitive functions with progress tracking.}
\item{\code{Exception$array_margins_not_compatible(actual, allowed)}}{Exception for using improper margins in the \code{BackendService$apply} operation.}
}
}
\description{
This class contains static methods for throwing exceptions with informative
messages.
}

