% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{pandemonium}
\alias{pandemonium}
\title{Shiny app for exploring clustering solutions}
\usage{
pandemonium(
  df,
  cov = NULL,
  is.inv = FALSE,
  exp = NULL,
  space2 = NULL,
  space2.cov = NULL,
  space2.exp = NULL,
  group = NULL,
  label = NULL,
  user_dist = NULL,
  dimReduction = list(tSNE = tSNE, umap = umap),
  getCoords = list(normal = normCoords),
  getScore = NULL
)
}
\arguments{
\item{df}{data frame of data, assumes space 1 but variables can be re-assigned in the app}

\item{cov}{covariance matrix (optional)}

\item{is.inv}{is the covariance matrix an inverse default FALSE}

\item{exp}{observable reference value (e.g. experimental measurement)}

\item{space2}{data frame assumed to be in space 2 but variables can be re-assigned in the app}

\item{space2.cov}{covariance matrix (optional)}

\item{space2.exp}{observable reference value (e.g. experimental measurement)}

\item{group}{grouping assignments}

\item{label}{point labels}

\item{user_dist}{input distance matrix (optional)}

\item{dimReduction}{named list of functions used for dimension reduction}

\item{getCoords}{named list containing functions to calculate coordinates}

\item{getScore}{named list containing functions to calculate scores to be plotted as bins and continuous value.}
}
\value{
No return value, called to initiate 'shiny' app
}
\description{
Opening the GUI to cluster the data points based on values in space2.
Coordinates and distances are computed on the fly, or can be entered
in the function call.
}
