% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nightlight_data.R
\name{get_nightlight_data}
\alias{get_nightlight_data}
\title{Download and Retrieve Nightlight Data}
\usage{
get_nightlight_data(
  year,
  month,
  version = "v10",
  destination_dir = NULL,
  timeout = 1200
)
}
\arguments{
\item{year}{`numeric` o `character` The year for which to download
nightlight data (e.g., 2020).}

\item{month}{`numeric` o `character` Month of the year (1–12).
Will be formatted as two digits (e.g., `"03"` for March).}

\item{version}{`character` Nightlight data version. Default is `"v10"`.}

\item{destination_dir}{`character` Directory where the downloaded
`.tif` file will be saved. Default is the current working directory `"."`.}

\item{timeout}{`numeric` Timeout in seconds for the download. Default is `1200` seconds.}
}
\value{
`character` o `NULL` Path to the downloaded `.tif` file.
  Returns `NULL` if no file was found or if an error occurred.
}
\description{
Downloads nightlight data from the Earth Observation Group's website.
It scrapes the website to locate and download the latest available
nightlight dataset for the specified year and month.
}
\details{
The function constructs the appropriate URL for the specified year,
month, and data version, then scrapes the directory listing to locate
the latest available `.tif` file. It downloads and saves the file to
the `destination_dir`. This function is useful for retrieving
nightlight data for studies involving human activity, urbanization,
and environmental monitoring.
}
\examples{
\donttest{
  # Download nightlight data for March 2021
  file_path <- get_nightlight_data(2021, 3)
  print(file_path)
}

}
