% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traits.R
\name{trait_description}
\alias{trait_description}
\title{Get a trait name and description for prompts}
\usage{
trait_description(
  name = c("overall_quality", "organization"),
  custom_name = NULL,
  custom_description = NULL
)
}
\arguments{
\item{name}{Character identifier for a built-in trait. One of
\code{"overall_quality"} or \code{"organization"}.
Ignored if \code{custom_description} is supplied.}

\item{custom_name}{Optional short label to use when supplying a
\code{custom_description}. Defaults to "Custom trait" if
\code{custom_description} is provided but \code{custom_name}
is \code{NULL}.}

\item{custom_description}{Optional full-text definition of a
custom trait. When supplied, built-in \code{name} values are
ignored and this text is returned instead.}
}
\value{
A list with two elements:
\describe{
\item{name}{Short display label for the trait (e.g., "Overall Quality").}
\item{description}{Full-text definition of the trait, suitable for
inclusion in the prompt.}
}
}
\description{
This helper returns both a short display name and a longer
description for a scoring trait. These can be inserted into
the prompt template via the \code{{TRAIT_NAME}} and
\code{{TRAIT_DESCRIPTION}} placeholders.
}
\examples{
td <- trait_description("overall_quality")
td$name
td$description

custom_td <- trait_description(
  custom_name = "Ideas",
  custom_description = "Quality and development of ideas in the writing."
)
custom_td$name
custom_td$description

}
