% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{parse_gemini_batch_output}
\alias{parse_gemini_batch_output}
\title{Parse Gemini batch JSONL output into a tibble of pairwise results}
\usage{
parse_gemini_batch_output(results_path, requests_tbl)
}
\arguments{
\item{results_path}{Path to the JSONL file produced by
\code{\link[=gemini_download_batch_results]{gemini_download_batch_results()}}.}

\item{requests_tbl}{Tibble/data frame with at least columns \code{custom_id},
\code{ID1}, \code{ID2}, and (optionally) \code{request}. If a \code{request} list-column is
present, it is used to detect whether \code{thinkingConfig.includeThoughts}
was enabled for that pair.}
}
\value{
A tibble with one row per request and columns:
\itemize{
\item \code{custom_id}, \code{ID1}, \code{ID2}
\item \code{model}, \code{object_type}, \code{status_code}, \code{result_type}, \code{error_message}
\item \code{thoughts}, \code{thought_signature}, \code{thoughts_token_count}
\item \code{content}, \code{better_sample}, \code{better_id}
\item \code{prompt_tokens}, \code{completion_tokens}, \code{total_tokens}
}
}
\description{
This reads a JSONL file created by \code{\link[=gemini_download_batch_results]{gemini_download_batch_results()}} and
converts each line into a row that mirrors the structure used for live
Gemini calls, including a \code{thoughts} column when the batch was run with
\code{include_thoughts = TRUE}.
}
\examples{
#' # This example assumes you have already:
# 1. Built Gemini batch requests with `build_gemini_batch_requests()`
# 2. Submitted and completed a batch job via the Gemini API
# 3. Downloaded the results using `gemini_download_batch_results()`
\dontrun{
# Path to a JSONL file created by `gemini_download_batch_results()`
results_path <- "gemini_batch_results.jsonl"

# Requests table used to build the batch (must contain custom_id, ID1, ID2)
# as returned by `build_gemini_batch_requests()`
requests_tbl <- readRDS("gemini_batch_requests.rds")

# Parse batch output into a tidy tibble of pairwise results
results <- parse_gemini_batch_output(
  results_path = results_path,
  requests_tbl = requests_tbl
)

results
}

}
