% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{paddle_preview_transaction}
\alias{paddle_preview_transaction}
\title{Preview a transaction}
\usage{
paddle_preview_transaction(
  items,
  customer_id = NULL,
  currency_code = NULL,
  discount_id = NULL,
  ignore_trials = NULL,
  customer_ip_address = NULL,
  address = NULL
)
}
\arguments{
\item{items}{List of lists. Required. Each must include `price_id` and `quantity`.}

\item{customer_id}{Character. Optional. Customer ID prefixed with "ctm_".}

\item{currency_code}{Character. Optional. Must be valid ISO 4217 code.}

\item{discount_id}{Character. Optional. Discount ID prefixed with "dsc_".}

\item{ignore_trials}{Logical. Optional. If TRUE, disables trial discounts.}

\item{customer_ip_address}{Character. Optional. Valid IPv4 or IPv6.}

\item{address}{Named list. Optional. Must include `country_code` (2-letter) and optionally `postal_code`.}
}
\value{
A list with previewed transaction data.
}
\description{
Sends a preview request to Paddle to simulate a transaction without creating it.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_preview_transaction(
  items = list(list(price_id = "pri_123", quantity = 2)),
  customer_id = "ctm_123",
  currency_code = "EUR",
  discount_id = "dsc_123",
  ignore_trials = TRUE,
  customer_ip_address = "8.8.8.8"
)
\dontshow{\}) # examplesIf}
}
