% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_k_means.R
\name{fuzzy_k_means}
\alias{fuzzy_k_means}
\title{Fuzzy k-means clustering}
\usage{
fuzzy_k_means(
  data,
  variables,
  number_cluster = 3:5,
  fuzzyness = 1.2,
  distance = "euclidean"
)
}
\arguments{
\item{data}{sf object}

\item{variables}{variables to use for clustering, if missing, all numeric
variables will be used}

\item{number_cluster}{\code{numeric} vector with number of final clusters}

\item{fuzzyness}{A number greater than 1 giving the degree of fuzzification.}

\item{distance}{\code{character} Must be one of the following:
If "euclidean", the mean square error, if "manhattan", the mean
absolute error is computed. Abbreviations are also accepted.}
}
\value{
a list with classification results and indices to select best number of
clusters.
}
\description{
Performs a vectorized fuzzy k-means clustering, this procedure
it is not spatial. The function is almost a wrapper of the function cmeans
from the package e1071. Is intended to be used when `KM-sPC` procedure is not
possible because data set has only 1 variable.
}
\examples{
library(sf)
data(wheat, package = 'paar')

# Transform the data.frame into a sf object
wheat_sf <- st_as_sf(wheat,
                     coords = c('x', 'y'),
                     crs = 32720)

# Run the fuzzy_k_means function
fuzzy_k_means_results <- fuzzy_k_means(wheat_sf,
                               variables = 'Tg',
                               number_cluster = 2:4)

# Print the summaryResults
fuzzy_k_means_results$summaryResults

# Print the indices
fuzzy_k_means_results$indices

# Print the cluster
head(fuzzy_k_means_results$cluster, 5)

# Combine the results in a single object
wheat_clustered <- cbind(wheat_sf, fuzzy_k_means_results$cluster)

# Plot the results
plot(wheat_clustered[, "Cluster_2"])
}
