% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depurate.R
\name{depurate}
\alias{depurate}
\title{Remove errors from spatial data}
\usage{
depurate(
  x,
  y,
  toremove = c("edges", "outlier", "inlier"),
  crs = NULL,
  buffer = -10,
  ylimitmax = NA,
  ylimitmin = 0,
  sdout = 3,
  ldist = 0,
  udist = 40,
  criteria = c("LM", "MP"),
  zero.policy = NULL,
  poly_border = NULL
)
}
\arguments{
\item{x}{an \code{sf} points object}

\item{y}{\code{character} with the name of the variable to use for
depuration/filtering process}

\item{toremove}{\code{character} vector specifying the procedure to
implement for errors removal. Default 'edges', 'outlier', 'inlier'.
See Details.}

\item{crs}{coordinate reference system: integer with the EPSG code,
or character with proj4string to convert coordinates if \code{x} has
longitude/latitude data}

\item{buffer}{\code{numeric} distance in meters to be removed. Negative
values are recommended}

\item{ylimitmax}{\code{numeric} of length 1 indicating the maximum limit
for the \code{y} variable. If \code{NA} \code{Inf} is assumed}

\item{ylimitmin}{\code{numeric} of length 1 indicating the minimum limit
for the \code{y} variable. If \code{NA} \code{-Inf} is assumed}

\item{sdout}{\code{numeric} values outside the interval
\eqn{mean ± sdout × sdout} values will be removed}

\item{ldist}{\code{numeric} lower distance bound to identify neighbors}

\item{udist}{\code{numeric} upper distance bound to identify neighbors}

\item{criteria}{\code{character} with "LM" and/or "MP" for methods to
identify spatial outliers}

\item{zero.policy}{default NULL, use global option value;
if FALSE stop with error for any empty neighbors sets,
if TRUE permit the weights list to be formed with zero-length
weights vectors}

\item{poly_border}{\code{sf} object with one polygon or NULL. Can be
the result of \code{concaveman::concaveman}}
}
\value{
an object of class \code{paar} with two elements:
\describe{
 \item{depurated_data}{\code{sf} object with the data after the removal
 process}
 \item{condition}{\code{character} vector with the condition of each
 observation}
 }
}
\description{
Data can be filtered by null, edge values, global
 outliers and spatial outliers or local defective observations. Default
 values are optimized for precision agricultural data.
}
\details{
Possible values for \code{toremove} are one or more elements of:
\describe{
  \item{edges}{All data points for a distance of \code{buffer} m from data
  edges are deleted.}
  \item{outlier}{Values that are outside the mean±\code{sdout} are removed}
  \item{inlier}{Local Moran index of spatial autocorrelation is calculated
  for each datum as a tool to identify inliers}
}
}
\examples{
library(sf)
data(barley, package = 'paar')
#Convert to an sf object
barley <- st_as_sf(barley,
                   coords = c("X", "Y"),
                   crs = 32720)
depurated <-
  depurate(barley,
           "Yield")

# Summary of depurated data
summary(depurated)

# Keep only depurate data
depurated_data <- depurated$depurated_data
# Combine the condition for all data
all_data_condition <- cbind(depurated, barley)
}
\references{
Vega, A., Córdoba, M., Castro-Franco, M. et al. Protocol for
automating error removal from yield maps. Precision Agric 20, 1030–1044
(2019). https://doi.org/10.1007/s11119-018-09632-8
}
