% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.R
\name{get_networks}
\alias{get_networks}
\title{Get the list of sub-networks}
\usage{
get_networks(
  data,
  centrality_degree_mod = "out",
  components_mod = "weak",
  network_min_genes = 10
)
}
\arguments{
\item{data}{adjacency data.frame}

\item{centrality_degree_mod}{mode of centrality degree for popularity calculation}

\item{components_mod}{mode of sub-network extraction methods}

\item{network_min_genes}{minimal number of gene elements required for extracted sub-networks}
}
\value{
list of tabl_graph objects
}
\description{
Get sub-networks based on given adjacency data.frame input
}
\examples{
example_data <- pGRNDB
expression_matrix <- example_data[["expression"]]
pseudotime_list <- example_data[["ptime"]]$PseudoTime
dtw_dist_matrix <- get_dtw_dist_mat(expression_matrix,
                                    pseudotime_list,
                                    cores=1)
adj_df <- matrix2adj(dtw_dist_matrix)
get_networks(adj_df,network_min_genes=5)
}
