% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.outForest}
\alias{predict.outForest}
\title{Out-of-Sample Application}
\usage{
\method{predict}{outForest}(
  object,
  newdata,
  replace = c("pmm", "predictions", "NA", "no"),
  pmm.k = 3L,
  threshold = object$threshold,
  max_n_outliers = Inf,
  max_prop_outliers = 1,
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class "outForest".}

\item{newdata}{A new \code{data.frame} to be assessed for numeric outliers.}

\item{replace}{Should outliers be replaced via predictive mean matching "pmm"
(default), by "predictions", or by \code{NA} ("NA").
Use "no" to keep outliers as they are.}

\item{pmm.k}{For \code{replace = "pmm"}, from how many nearest OOB prediction neighbours
(from the original non-outliers) to sample?}

\item{threshold}{Threshold above which an outlier score is considered an outlier.
The default is 3.}

\item{max_n_outliers}{Maximal number of outliers to identify.
Will be used in combination with \code{threshold} and \code{max_prop_outliers}.}

\item{max_prop_outliers}{Maximal relative count of outliers.
Will be used in combination with \code{threshold} and \code{max_n_outliers}.}

\item{seed}{Integer random seed.}

\item{...}{Further arguments passed from other methods.}
}
\value{
An object of class "outForest".
}
\description{
Identifies outliers in new data based on previously fitted "outForest" object.
The result of \code{predict()} is again an object of class "outForest".
All its methods can be applied to it.
}
\examples{
(out <- outForest(iris, allow_predictions = TRUE))
iris1 <- iris[1, ]
iris1$Sepal.Length <- -1
pred <- predict(out, newdata = iris1)
outliers(pred)
Data(pred)
plot(pred)
plot(pred, what = "scores")
}
\seealso{
\code{\link[=outForest]{outForest()}}, \code{\link[=outliers]{outliers()}}, \code{\link[=Data]{Data()}}
}
