% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marginal_probabilities.R
\encoding{UTF-8}
\name{marginal_probabilities}
\alias{marginal_probabilities}
\title{Computes the marginal probabilities of an ordinal time series}
\usage{
marginal_probabilities(series, states)
}
\arguments{
\item{series}{An OTS (numerical vector with integers).}

\item{states}{A numerical vector containing the corresponding
states}
}
\value{
A vector with the marginal probabilities.
}
\description{
\code{marginal_probabilities} returns a vector with the marginal
probabilities of an ordinal time series
}
\details{
Given an OTS of length \eqn{T} with range \eqn{\mathcal{S}=\{s_0, s_1, s_2, \ldots, s_n\}} (\eqn{s_0 < s_1 < s_2 < \ldots < s_n}),
\eqn{\overline{X}_t=\{\overline{X}_1,\ldots, \overline{X}_T\}}, the function computes the
vector \eqn{\widehat{\boldsymbol p} =(\widehat{p}_0, \ldots, \widehat{p}_n)},
with \eqn{\widehat{p}_i=\frac{N_i}{T}}, where \eqn{N_i} is the number
of elements equal to \eqn{s_i} in the realization \eqn{\overline{X}_t}.
}
\examples{
vector_mp <- marginal_probabilities(series = AustrianWages$data[[100]],
states = 0 : 5) # Computing the vector of
# marginal probabilities for one series in dataset AustrianWages
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
