% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variantsQuery.R
\name{variantsQuery}
\alias{variantsQuery}
\title{Retrieve Variants data for a specified study locus.}
\usage{
variantsQuery(studyLocusId, size = 500, index = 0)
}
\arguments{
\item{studyLocusId}{Character: ID of the target study locus (e.g., "fa375739ca2a6b825ce5cc69d117e84b").}

\item{size}{Integer: Number of records to retrieve (default: 500).}

\item{index}{Integer: Page index for pagination (default: 0).}
}
\value{
Returns a tibble containing variants data for the specified study locus.
}
\description{
This function queries the Open Targets GraphQL API to retrieve variants data
for a specified study locus.
}
\examples{
\dontrun{
result <- variantsQuery(studyLocusId = "fa375739ca2a6b825ce5cc69d117e84b", 
size = 500, index = 0)
}
}
