% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{osm_other_tags_list}
\alias{osm_other_tags_list}
\title{Generate a List from the 'other_tags' Column in OSM PBF Data}
\usage{
osm_other_tags_list(x, values = FALSE, split = "\\",\\"|\\"=>\\"", ...)
}
\arguments{
\item{x}{character. The 'other_tags' column of an imported osm.pbf file.}

\item{values}{logical. \code{TRUE} also includes the values of tags.}

\item{split}{character. Pattern passed to \code{\link{strsplit}} to split up \code{x}.}

\item{\dots}{further arguments to \code{\link{strsplit}}.}
}
\value{
a list of tags as character vectors, or a nested list of tags and values if \code{values = TRUE}.
}
\description{
Generate a List from the 'other_tags' Column in OSM PBF Data
}
\examples{
# See Examples at ?osmclass for full examples

# Extract 'other_tags' as list
other_tags <- osm_other_tags_list(djibouti_points$other_tags)
other_tags[1:10]

# Count frequency (showing top 10)
sort(table(unlist(other_tags)), decreasing = TRUE)[1:10]

# Also include values
other_tags_values <- osm_other_tags_list(djibouti_points$other_tags, values = TRUE)
other_tags_values[1:10]

}
\seealso{
\link{osmclass-package}
}
