% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify-diabetes.R
\name{classify_diabetes}
\alias{classify_diabetes}
\title{Classify diabetes status using Danish registers.}
\usage{
classify_diabetes(
  kontakter,
  diagnoser,
  lpr_diag,
  lpr_adm,
  sysi,
  sssy,
  lab_forsker,
  bef,
  lmdb,
  stable_inclusion_start_date = "1998-01-01"
)
}
\arguments{
\item{kontakter}{The contacts information table from the LPR3 patient register}

\item{diagnoser}{The diagnoses information table from the LPR3 patient register}

\item{lpr_diag}{The diagnoses information table from the LPR2 patient register}

\item{lpr_adm}{The administrative information table from the LPR2 patient register}

\item{sysi}{The SYSI table from the health service register}

\item{sssy}{The SSSY table from the health service register}

\item{lab_forsker}{The register for laboratory results for research}

\item{bef}{The BEF table from the civil register}

\item{lmdb}{The LMDB table from the prescription register}

\item{stable_inclusion_start_date}{Cutoff date after which inclusion events
are considered true incident diabetes cases. Defaults to "1998-01-01",
which is one year after the data on pregnancy events from the Patient Register
are considered valid for dropping gestational diabetes-related purchases of
glucose-lowering drugs. This default assumes that the user is using LPR and
LMDB data from at least Jan 1 1997 onward. If the user only has access to LPR
and LMDB data from a later date, this parameter should be set to one year
after the beginning of the user's data coverage.}
}
\value{
The same object type as the input data, which would be a
\code{\link[duckplyr:duckdb_tibble]{duckplyr::duckdb_tibble()}} type object.
}
\description{
This function requires that each source of register data is represented
as a single DuckDB object in R (e.g. a connection to Parquet files).
Each DuckDB object must contain a single table covering all years of
that data source, or at least the years you have and are interested
in.
}
\examples{
# Can't run this multiple times, will cause an error as the table
# has already been created in the DuckDB connection.
register_data <- registers() |>
  names() |>
  simulate_registers() |>
  purrr::map(duckplyr::as_duckdb_tibble) |>
  purrr::map(duckplyr::as_tbl)

classify_diabetes(
  kontakter = register_data$kontakter,
  diagnoser = register_data$diagnoser,
  lpr_diag = register_data$lpr_diag,
  lpr_adm = register_data$lpr_adm,
  sysi = register_data$sysi,
  sssy = register_data$sssy,
  lab_forsker = register_data$lab_forsker,
  bef = register_data$bef,
  lmdb = register_data$lmdb
)
}
\seealso{
See the \link{osdc} vignette for a detailed
description of the internal implementation of this classification function.
}
