% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/o.R
\name{ort}
\alias{ort}
\title{Create a data frame representation of an image}
\usage{
ort(
  img,
  bg = 1,
  grid_size = function(x) {
     1/(250 * (1.0001 - x))
 },
  grid_offset = function(x) {
     sin(x * 100) * 10
 }
)
}
\arguments{
\item{img}{An \code{\link[imager]{cimg}} object containing an image (from 'imager')}

\item{bg}{Background color in case of alpha (default is white)}

\item{grid_size}{Size of grid used for conversion}

\item{grid_offset}{Offset of grid used for conversion}
}
\value{
A data frame with two columns, `x` and `y` that
hopefully resembles the image when plotted
}
\description{
Takes a \code{\link[imager]{cimg}} object and
attempts to create a data frame that, when plotted using the default
\code{\link[graphics]{plot}} in base R, looks like the original image.
}
\examples{
# Load image using imager
pineapple_img = load.image(system.file("FallingPineapple_16x16.png", package = "ort"))

# Convert to data frame plot
pineapple_ort = ort(pineapple_img)
plot(pineapple_ort)

\donttest{
# Example with alpha background
alph_img = load.image(system.file("alpha_gradient_test.png", package = "ort"))

# default assumes bg = 1 (white background)
alph_ort = ort(alph_img)
plot(alph_ort)

alph_ort_grey = ort(alph_img, bg = 0.5)
plot(alph_ort_grey)
}
}
