% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rpp_read.r
\name{rpp_read2}
\alias{rpp_read2}
\title{Read function}
\usage{
rpp_read2(dat, selected = c(2, 3, 4, 0, 0, 1, 0, 0), ...)
}
\arguments{
\item{dat}{dataframe of input}

\item{selected}{the user should input the number of the columns that represent
strain-smoothed (gamma), strain rate-smoothed (gamma dot), stress smoothed (tau recon), Elast-Stress (FTtau_e), Visco-Stress (FTtau_v), raw time (time), raw stress (tau), raw strain (gamma)
i.e. selected=c(2, 3, 4, 0, 0, 1, 0, 0) means that the second column of your data is the strain rate smoothed, the third column is the stress smoothed, the stress smoothed is the fourth column in the original data,
and finally that we do not have data for the raw stress and raw strain}

\item{...}{parameters of read.csv}
}
\value{
a dataframe with all the columns assigned
}
\description{
This function reads data from a dataframe
}
\examples{
data(mydata)
df <- rpp_read2(mydata , selected=c(2, 3, 4, 0, 0, 1, 0, 0))
 
}
\author{
Giorgio Luciano and Serena Berretta, Simon Rogers Group for Soft Matter (matlab version)
}
