% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_pull}
\alias{orderly_location_pull}
\title{Pull one or more packets from a location}
\usage{
orderly_location_pull(
  expr,
  name = NULL,
  location = NULL,
  fetch_metadata = FALSE,
  recursive = NULL,
  options = NULL,
  root = NULL
)
}
\arguments{
\item{expr}{The query expression. A \code{NULL} expression matches everything.}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}

\item{recursive}{If non-NULL, a logical, indicating if we should
recursively pull all packets that are referenced by the packets
specified in \code{id}.  This might copy a lot of data!  If \code{NULL},
we default to the value given by the the configuration option
\code{require_complete_tree}.}

\item{options}{\strong{DEPRECATED}. Please don't use this any more, and
instead use the arguments \code{location}, \code{allow_remote} and
\code{fetch_metadata} directly.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Invisibly, the ids of packets that were pulled
}
\description{
Pull one or more packets (including all their files) into this
archive from one or more of your locations. This will make files
available for use as dependencies (e.g., with
\code{\link[=orderly_dependency]{orderly_dependency()}}).
}
\details{
It is possible that it will take a long time to pull packets, if
you are moving a lot of data or if you are operating over a slow
connection.  Cancelling and resuming a pull should be fairly
efficient, as we keep track of files that are copied over even in
the case of an interrupted pull.
}
\examples{
# Two roots, one local and one representing some remote orderly location:
local <- orderly_example()
remote <- orderly_example()

# We create a packet in the remote root:
orderly_run("data", root = remote)

# Add the remote as a path location to the local root:
orderly_location_add_path("remote", remote, root = local)

# Pull a packet into our local version
orderly_location_pull(quote(latest(name == "data")),
                      fetch_metadata = TRUE, root = local)
}
