% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{orderly_compare_packets}
\alias{orderly_compare_packets}
\title{Compare the metadata and contents of two packets.}
\usage{
orderly_compare_packets(
  target,
  current,
  location = NULL,
  allow_remote = NULL,
  fetch_metadata = FALSE,
  root = NULL
)
}
\arguments{
\item{target}{The id of the packet to use in the comparison.}

\item{current}{The id of the other packet against which to compare.}

\item{location}{Optional vector of locations to pull from. We
might in future expand this to allow wildcards or exceptions.}

\item{allow_remote}{Logical, indicating if we should allow packets
to be found that are not currently unpacked (i.e., are known
only to a location that we have metadata from). If this is
\code{TRUE}, then in conjunction with \code{\link[=orderly_dependency]{orderly_dependency()}}
you might pull a large quantity of data.  The default is \code{NULL}. This is
\code{TRUE} if remote locations are listed explicitly as a character
vector in the \code{location} argument, or if you have specified
\code{fetch_metadata = TRUE}, otherwise \code{FALSE}.}

\item{fetch_metadata}{Logical, indicating if we should pull
metadata immediately before the search. If \code{location} is given,
then we will pass this through to
\code{\link[=orderly_location_fetch_metadata]{orderly_location_fetch_metadata()}} to filter locations
to update.  If pulling many packets in sequence, you \emph{will} want
to update this option to \code{FALSE} after the first pull, otherwise
it will update the metadata between every packet, which will be
needlessly slow.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
An object of class orderly_comparison. The object can be printed to
get a summary description of the differences, or passed to
\code{\link[=orderly_comparison_explain]{orderly_comparison_explain()}} to display more details.
}
\description{
Insignificant differences in the metadata (e.g., different dates
and packet IDs) are excluded from the comparison.
}
\examples{

# Here are two packets that are equivalent, differing only in id
# and times:
path <- orderly_example()
id1 <- orderly_run("data", root = path)
id2 <- orderly_run("data", root = path)
orderly_compare_packets(id1, id2, root = path)

# A more interesting comparison:
id1 <- orderly_run("parameters", list(max_cyl = 6), root = path)
id2 <- orderly_run("parameters", list(max_cyl = 4), root = path)
cmp <- orderly_compare_packets(id1, id2, root = path)
cmp

# A verbose comparison will show differences in the constituent
# components of each packet:
orderly_comparison_explain(cmp, verbose = TRUE)
}
