% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naming.R
\name{naming_formats}
\alias{naming_formats}
\alias{option_name_default}
\alias{envvar_name_default}
\alias{envvar_name_generic}
\title{Naming Convention Formatters}
\usage{
option_name_default(package, option)  # "package.option"

envvar_name_default(package, option)  # "R_PACKAGE_OPTION"

envvar_name_generic(package, option)  # "PACKAGE_OPTION"
}
\arguments{
\item{package, option}{The package name and internal option name used for
generating a global R option and environment variable name. As these
functions are often provided as values, their arguments rarely need to be
provided by package authors directly.}
}
\value{
A character value to use as the global option name or environment
variable name
}
\description{
This family of functions is used internally to generate global option and
environment variable names from the package name and internal option name.
}
\section{Functions}{
\itemize{
\item \code{option_name_default()}: A default naming convention, producing a global R option name from the
package name and internal option name (\code{mypackage.myoption})

\item \code{envvar_name_default()}: A default naming convention, producing an environment variable name from the
package name and internal option name (\code{R_MYPACKAGE_MYOPTION})

\item \code{envvar_name_generic()}: A generic naming convention, producing an environment variable name from the
package name and internal option name. Useful when a generic convention might
be used to share environment variables with other tools of the same name, or
when you're confident that your R package will not conflict with other tools.
(\code{MYPACKAGE_MYOPTION})

}}
\seealso{
naming
}
\concept{naming_formats}
\keyword{naming_formats}
