% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sample.func}
\alias{sample.func}
\title{Unified function sampling interface.}
\usage{
sample.func(FUN.name, n, k, method = "lh.sample", ...)
}
\arguments{
\item{FUN.name}{The name of the function to sample.}

\item{n}{The number of sample points.}

\item{k}{The number of dimensions to sample.}

\item{method}{The sampling method.}

\item{...}{Additional arguments passed to \code{FUN.name}.}
}
\value{
A data frame consisting of n rows with columns x1..xk and 
                y1..yz where z is the number of outputs of the function.
}
\description{
Provides a unified interface to sampling all functions. One just needs to
specify the name of the function to sample, the number of samples, the
dimensionality, and the sampling method and the library will take care
of the rest.
}

