% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergenceplot.R
\name{convergenceplot}
\alias{convergenceplot}
\title{Convergence plot}
\usage{
convergenceplot(yyy, refline = c(0.002, 1e-05))
}
\arguments{
\item{yyy}{a \code{\link{optical}} object; the output of a call \code{\link[=optical]{optical()}}}

\item{refline}{reference line}
}
\value{
A convergence plot is displayed.
}
\description{
Convergence plots displaying efficiency of design, violations of equivalence
theorem, and alpha(Step length used) vs. iteration number. These plot are
suitable for monitoring the convergence of optimal item calibration algorithm.
}
\details{
Convergence plots have three panel.
\itemize{
\item {First panel monitors efficiency of design vs. iteration number}
\item {Second panel monitors violations of equivalence theorem vs. iteration number}
\item {Third panel monitors step size used vs. iteration number}
}
}
\examples{
# 2PL-models for two items; parameters (a, b)=(1.6, -1) and (1.6, 1), respectively
ip <- cbind(c(1.6, 1.6),c(-1, 1))

yyy <- optical(ip)

convergenceplot(yyy, refline=c(0.002, 0.001*0.005/0.45))
}
\seealso{
\code{\link{drawdesign}}
}
