% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dispatch-simulations.R
\name{dispatch_simulations}
\alias{dispatch_simulations}
\title{Execute simulations defined in a optic_simulation object}
\usage{
dispatch_simulations(object, seed = NULL, use_future = FALSE, verbose = 0, ...)
}
\arguments{
\item{object}{Simulation scenarios object created using optic_simulation}

\item{seed}{Specified as either NULL or a numeric. Sets a seed, which is becomes an index in results, for
each independent set of simulations in optic_simulation.}

\item{use_future}{Runs simulation scenarios in parallel. Default FALSE, set to TRUE if you have already setup a future
plan (e.g., multiprocess, cluster, etc) and would like for the iterations to
be run in parallel.}

\item{verbose}{Default TRUE. IF TRUE, provides details on what's currently running.}

\item{...}{additional parameters to be passed to future_apply. User can pass future.globals and future.packages if your code relies on additional packages}
}
\value{
A list of dataframes, where each list entry contains results for a set of simulation parameters, with dataframes containing estimated treatment effects and summary statistics by model and  draw.
}
\description{
Execute simulations defined in a optic_simulation object
}
\examples{
# Set up a basic model and simulation scenario:
data(overdoses)

eff <- 0.1*mean(overdoses$crude.rate, na.rm = TRUE)
form <- formula(crude.rate ~ state + year + population + treatment_level)
mod <- optic_model(name = 'lin', 
                   type = 'reg', 
                   call = 'lm', 
                   formula = form, 
                   se_adjust = 'none')

sim <- optic_simulation(x = overdoses, 
                        models = list(mod), 
                        method = 'no_confounding', 
                        unit_var = 'state', 
                        treat_var = 'state',
                        time_var = 'year', 
                        effect_magnitude = list(eff), 
                        n_units = 2, 
                        effect_direction = 'pos', 
                        iters = 2,
                        policy_speed = 'instant', 
                        n_implementation_periods = 1)

# Finally, dispatch the simulation:
dispatch_simulations(sim)
}
