% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optR.R
\name{optR.formula}
\alias{optR.formula}
\title{Optimization & predictive modelling Toolsets}
\usage{
\method{optR}{formula}(formula, data = list(), weights = NULL,
  method = c("gauss, LU, gaussseidel", "cgm", "choleski"), iter = 500,
  tol = 1e-07, keep.data = TRUE, contrasts = NULL, ...)
}
\arguments{
\item{formula}{: formula to build model}

\item{data}{: data used to build model}

\item{weights}{: Observation weights}

\item{method}{: "gauss" for gaussian elimination and "LU" for LU factorization}

\item{iter}{: Number of Iterations}

\item{tol}{: Convergence tolerance}

\item{keep.data}{: If TRUE returns input data}

\item{contrasts}{: Data frame contract values}

\item{...}{: S3 Class}
}
\value{
U        : Decomposed matrix for Gauss-ELimination Ax=b is converted into Ux=c where U is upper triangular matrix for LU decomposition U contain the values for L & U decomposition LUx=b

c        : transformed b & for LU transformation c is y from equation Ux=y

estimates  : Return x values for linear system
}
\description{
optR package to perform the optimization using numerical methods
}
\examples{
# Solving equation Ax=b
b<-matrix(c(-14,36, 6), nrow=3,ncol=1,byrow=TRUE)
A<-matrix(c(6,-4,1, -4,6,-4,1,-4,6), nrow=3,ncol=3, byrow = TRUE)
Z<-optR(b~A-1, method="gauss") # -1 to remove the constant vector

Z<-optR(b~A-1, method="LU") # -1 to remove the constant vector

require(utils)
set.seed(129)
n <- 10 ; p <- 4
X <- matrix(rnorm(n * p), n, p) # no intercept!
y <- rnorm(n)
data<-cbind(X, y)
colnames(data)<-c("var1", "var2", "var3", "var4", "y")
Z<-optR(y~var1+var2+var3+var4+var1*var2-1, data=data.frame(data), method="cgm")

}
\author{
PKS Prakash
}

