% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/public.R
\name{experimental_results}
\alias{experimental_results}
\title{Report the results of the experiment as well as confidence intervals.}
\usage{
experimental_results(xs, ys, alpha = 0.05, B = 1000)
}
\arguments{
\item{xs}{The design}

\item{ys}{The measurements of the response}

\item{alpha}{\code{1 - alpha} is the confidence of the computed intervals. Default is \code{0.05}.}

\item{B}{For the confidence interval methods with an embedded bootstrap (or resampling), the number
of resamples (defaults to \code{1000}).}
}
\value{
A list object containing the estimate as well as confidence intervals and parameters.
}
\description{
Report the results of the experiment as well as confidence intervals.
}
\examples{
n = 10 
xmin = 5 / 15
xmax = 19 / 1
xs = runif(n, xmin, xmax)
ys = 2 + 3 * xs + rnorm(n)
experimental_results_info = experimental_results(xs, ys)
}
\author{
Adam Kapelner
}
