% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_frames.R
\name{get_Metadata}
\alias{get_Metadata}
\alias{get_Metadata.Hist}
\alias{get_Metadata.MSE}
\alias{get_Metadata.list}
\alias{get_Metadata.MMSE}
\title{Extract the meta-data from a \code{Hist} or \code{MSE} object}
\usage{
get_Metadata(x)

\method{get_Metadata}{Hist}(x)

\method{get_Metadata}{MSE}(x)

\method{get_Metadata}{list}(x)

\method{get_Metadata}{MMSE}(x)
}
\arguments{
\item{x}{An object of class \code{Hist}, \code{MSE}, or a list of \code{Hist} or \code{MSE} objects}
}
\value{
A named list with elements:\tabular{ll}{
\code{nsim} \tab The number of simulations \cr
\code{nage} \tab The number of age classes \cr
\code{Ages} \tab The age classes \cr
\code{nyear} \tab The number of historical years \cr
\code{Hist.Years} \tab A data.frame with the historical years in the \code{Year} column \cr
\code{proyears} \tab The number of projection years \cr
\code{Pro.Years} \tab A data.frame with the projection years in the \code{Year} column \cr
\code{All.Years} \tab A data.frame with the historical and the projection years in the \code{Year} column \cr
\code{nMPs} \tab The number of MPs (if \code{x} is an object of class \code{MSE}) \cr
\code{MPs} \tab The MPs (if \code{x} is an object of class \code{MSE}) \cr
}
}
\description{
Extract the meta-data from a \code{Hist} or \code{MSE} object
}
\details{
If \code{x} is a list of objects, each object must
have identical structure, i.e., same number of simulations,
same number of age-classes, historical and projection years,
management procedures, etc
}
