% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_diagnostic_missings.R
\name{create_diagnostic_missings}
\alias{create_diagnostic_missings}
\title{Create Diagnostic Missing Values in Data}
\usage{
create_diagnostic_missings(
  x,
  Prob = 0.1,
  mnarity = 0,
  mnarshape = 1,
  lowOnly = FALSE,
  seed,
  maxAttempts = 1000
)
}
\arguments{
\item{x}{Data frame or matrix with numeric data. May contain existing missing values}

\item{Prob}{Numeric between 0 and 1. Proportion of non-missing values to set as missing (default: 0.1)}

\item{mnarity}{Numeric between 0 and 1. Proportion of MNAR (vs MCAR/MAR) missingness (default: 0)}

\item{mnarshape}{Numeric >= 1. Shape parameter for MNAR probability distribution (default: 1)}

\item{lowOnly}{Logical. If TRUE, only creates missings for low values in MNAR case (default: FALSE)}

\item{seed}{Integer. Random seed for reproducibility (default: 42)}

\item{maxAttempts}{Integer. Maximum number of attempts to generate valid missing pattern (default: 100)}
}
\value{
A list with two elements:
  \item{toDelete}{List of row indices where values were set to missing, one vector per column}
  \item{missData}{Data frame with introduced missing values}
}
\description{
Introduces additional missing values into a dataset (which may already contain missings)
using various missingness mechanisms: Missing Completely at Random (MCAR), Missing at
Random (MAR), and Missing Not at Random (MNAR). Missing values are only inserted at
positions that currently contain actual values (non-NA).
}
\details{
The function creates missing values using a combination of mechanisms:
\itemize{
  \item MCAR: Random missingness independent of data values (controlled by 1-mnarity)
  \item MAR/MNAR: Value-dependent missingness (controlled by mnarity)
}

The shape of the MNAR probability distribution is controlled by mnarshape.
When lowOnly = TRUE, MNAR mechanism targets only low values; otherwise it targets
extreme values (both high and low).

The function ensures that no row ends up with all values missing by excluding
positions from the sampling pool that would create completely missing rows.
}
\examples{
# Create 10\% MCAR missings
result <- create_diagnostic_missings(
  x = iris[,1:4],
  Prob = 0.1,
  mnarity = 0
)

# Create 20\% missings with 50\% MNAR targeting low values
result <- create_diagnostic_missings(
  x = iris[,1:4],
  Prob = 0.2,
  mnarity = 0.5,
  lowOnly = TRUE
)

}
\keyword{datagen}
