% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{list2edges}
\alias{list2edges}
\title{Convert list to edge matrix}
\usage{
list2edges(annotated.char.list, col_order_inverse = FALSE)
}
\arguments{
\item{annotated.char.list}{character list. A character list with ontology annotations.}

\item{col_order_inverse}{logical. The default creates the first columns consisting of character IDs and the second columns consisting of ontology annotations.
The inverse order changes the columns order.}
}
\value{
Two-column matrix.
}
\description{
Takes a list of charater annotations and creates an edge matrix comprising two columns: from and to.
The list to table conversion can be done using ldply function from plyr package: plyr::ldply(list, rbind).
}
\examples{
annot_list <- list("CH1" = c("HAO:0000933", "HAO:0000958"), "CH2" = c("HAO:0000833", "HAO:0000258"))
list2edges(annot_list)

}
\author{
Sergei Tarasov
}
