% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paramo_functions.R
\name{discr_Simmap}
\alias{discr_Simmap}
\title{Reading unsummarized simmap for one tree}
\usage{
discr_Simmap(tree, res)
}
\arguments{
\item{tree}{simmap or phylo object.}

\item{res}{integer. A resolution value for the discretization of tree edges.}
}
\value{
A simmap or phylo object.
}
\description{
Discretizes tree edges into identical bins given a selected resolution value.
}
\examples{
data("hym_stm")
tree <- hym_stm[[1]][[1]]
stm_discr <- discr_Simmap(tree, res = 100)
# Check some arbitrary branch.
tree$maps[[8]]
stm_discr$maps[[8]]
sum(tree$maps[[8]])
sum(stm_discr$maps[[8]])

}
\author{
Sergei Tarasov
}
