% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ollama.R
\name{copy}
\alias{copy}
\title{Copy a model}
\usage{
copy(source, destination, endpoint = "/api/copy", host = NULL)
}
\arguments{
\item{source}{The name of the model to copy.}

\item{destination}{The name for the new model.}

\item{endpoint}{The endpoint to copy the model. Default is "/api/copy".}

\item{host}{The base URL to use. Default is NULL, which uses Ollama's default base URL.}
}
\value{
A httr2 response object.
}
\description{
Creates a model with another name from an existing model.
}
\examples{
\dontshow{if (test_connection(logical = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
copy("llama3", "llama3_copy")
delete("llama3_copy")  # delete the model was just got copied
\dontshow{\}) # examplesIf}
}
\references{
\href{https://github.com/ollama/ollama/blob/main/docs/api.md#copy-a-model}{API documentation}
}
