% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{smax}
\alias{smax}
\title{The softmax function.}
\usage{
smax(eta, g = NULL)
}
\arguments{
\item{eta}{numeric array of the odds.
The odds are de-meaned within each group.}

\item{g}{a vector giving the group indices. If \code{NULL},
then we assume only one group is in consideration.}
}
\value{
the exponentiated data normalized.
For the row-wise version, each row is soft maxed.
}
\description{
The softmax function: exponentiate a vector and then
normalize.
}
\details{
Given vector \eqn{\eta} for a single group, essentially
computes vector \eqn{\mu} defined by
\deqn{\mu_i = \frac{\exp{\eta_i}}{\sum_j \exp{\eta_j}}.}

Note that this computation should be invariant with respect
to level shifts of the \eqn{\eta}, and thus we de-mean
the odds first.
}
\note{
This function can deal with overflow in a semi-coherent way.
}
\examples{
# we can deal with large values:
set.seed(2345)
eta <- rnorm(12,sd=1000)
smax(eta)
}
\seealso{
\code{\link{normalize}}, \code{\link{inv_smax}}.
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
