% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_indices.R
\name{map_indices}
\alias{map_indices}
\title{Map indices}
\usage{
map_indices(indices, n)
}
\arguments{
\item{indices}{[\code{integer()}]\cr
An index vector, where each element specifies a group to be mapped from the
sequence.}

\item{n}{[\code{integer}]\cr
The size of each group of consecutive indices.}
}
\value{
An \code{integer} \code{vector}, containing the mapped indices according to the
specified group size.
}
\description{
This function maps indices from an input vector to corresponding sequences of
grouped indices. Each element from the input specifies a group to be mapped
from the sequence, determined by the grouping size \code{n}.
}
\details{
This function is useful when working with indices arranged in fixed-size
groups, where each group can be referenced by a single index. For example, if
indices are structured in chunks of 3, calling this function with \code{n = 3}
will map the corresponding groups of 3 consecutive indices for the given
input indices, see the examples.
}
\examples{
# Example: Map indices based on groups of 3
map_indices(c(1, 3, 5), 3)
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{equidistant_vectors}()},
\code{\link{insert_vector_entry}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{indexing}
