% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.2m.111.R
\name{power.2m.111}
\alias{power.2m.111}
\title{Budget and/or sample size, power, MDES calculation for MRTs investigating
    mediation effects with individual-level mediators}
\usage{
power.2m.111(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  a = NULL,
  b = NULL,
  power = NULL,
  m = NULL,
  test = NULL,
  n = NULL,
  p = NULL,
  c1 = NULL,
  c1t = NULL,
  c2 = NULL,
  r12 = 0,
  r22m = 0,
  r12m = 0,
  icc.m = NULL,
  omega = NULL,
  icc = NULL,
  J = NULL,
  q = 0,
  q.a = 0,
  q.b = 0,
  max.iter = 300,
  powerlim = NULL,
  Jlim = NULL,
  mlim = NULL,
  rounded = TRUE
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{returned object from function \code{\link{od.2m.111}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{a}, \code{b},
\code{c1}, \code{c1t}, and \code{p}
used or solved in function \code{\link{od.2m.111}} will
be passed to the current function;
only the values of \code{p} and \code{n} that specified or solved in
function \code{\link{od.2m.111}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{specify the constrained value of
\code{p} and/or \code{n} in a list format to overwrite that/those
from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{a}{The treatment effect on the mediator.}

\item{b}{The within treatment correlation between the outcome and the mediator.}

\item{power}{Statistical power.}

\item{m}{Total budget.}

\item{test}{The type of test will be used to detect mediation effects. Default is
the joint significance test (i.e., test = "joint").
Another choice is the Sobel test by specifying the argument as test = "sobel".}

\item{n}{The level-1 sample size per level-2 unit.}

\item{p}{The proportion of level-1 units to be assigned to treatment.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2}{The cost of sampling one level-2 unit (site).}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22m}{The proportion of variance of site-specific treatment
effect explained by covariates.}

\item{r12m}{The proportion of within treatment mediator variance at the level one
explained by covariates.}

\item{icc.m}{The intraclass correlation coefficient for the mediator.}

\item{omega}{The standardized variance of site-specific treatment effect.}

\item{icc}{The unconditional intraclass correlation coefficient (ICC) in population or in
each treatment condition.}

\item{J}{The number of sites.}

\item{q}{The number of covariates at level 2.}

\item{q.a}{The number of covariates at the individual level of the mediator model
(except the treatment indicator).}

\item{q.b}{The number of covariates in the outcome model (except the treatment indicator
and the mediator).}

\item{max.iter}{Maximal number of function evaluations when used as
the stopping criterion. Default is 200.}

\item{powerlim}{The range for solving the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Jlim}{The range for searching the root of level-2 sample size (\code{J}) numerically,
default is c(4, 10e10).}

\item{mlim}{the range for searching the root of budget (\code{m}) numerically,
default value is the costs sampling \code{nlim} units.}

\item{rounded}{Logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (or required sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power and
    power under a fixed budget
    for multisite-randomized trials (MRTs) with individual mediators
    probing mediation effects.
    It also can perform conventional power analyses
    (e.g., required sample size and power calculation).
}
