% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocsManager.R
\docType{class}
\name{ocsManager}
\alias{ocsManager}
\title{ocsManager}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling an ocsManager
}
\description{
ocsManager

ocsManager
}
\examples{
\dontrun{
   #Not Run:
   #Connect to an OCS API
   OCS <- ocsManager$new(url = ocs_url, user = ocs_user, pwd = ocs_pwd, logger = "DEBUG")
   version <- OCS$getVersion()
   caps <- OCS$getCapabilities()
   
   #OCS User Provisioning API
   #-------------------------------------
   #users
   users <- OCS$getUsers() #get users
   user <- OCS$getUser("admin") #get a user
   user.df <- OCS$getUser("admin", TRUE) #the same user as data.frame
   added <- OCS$addUser("john.doe", password = "ocs4john") #add a user
   disabled <- OCS$disableUser("john.doe") #disable a user
   enabled <- OCS$enableUser("john.doe") #enable auser
   edited <- OCS$editUser("john.doe", key = "display", value = "John Doe") #edit user
   #edit some user field
   edited2 <- OCS$editUserDisplayName("john.doe", displayName = "John Doe Jr.") 
   deleted <- OCS$deleteUser("john.doe")
   
   #groups
   admingroups <- OCS$getUserGroups("admin")
   groups <- OCS$getGroups()
   added <- OCS$addGroup("scientists") #add a new group
   sc_group <- OCS$getGroup("scientists") #get group details
   added <- OCS$addToGroup("john.doe", "scientists") #add user to group
   removed <- OCS$removeFromGroup("john.doe", "scientists") #remove user from group
   deleted <- OCS$deleteGroup("scientists")
   
   #OCS Webdav API
   #-------------------------------------
   #list files
   files <- OCS$listFiles()
   subfiles <- OCS$listFiles("Documents")
   #make collection
   OCS$makeCollection("myfolder")
   subfiles <- OCS$listFiles("myfolder")
   #upload a file?
   filename <- "magic.txt"
   file.create(filename); writeLines("ocs4R is great", filename)
   #we upload the file in 'Documents' folder
   OCS$uploadFile(filename, "/Documents")
   #check if file is uploaded
   OCS$listFiles('Documents')
   
   #OCS Sharing API
   #-------------------------------------
   #let's add a user with User provisioning API
   added <- OCS$addUser("john.doe", password = "ocs4john") #add a user
   #let's share the previously uploaded file with John Doe
   OCS$shareWithUser("/Documents", filename, "john.doe")
}

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{manager}
\keyword{ocs}
\section{Super class}{
\code{\link[ocs4R:ocs4RLogger]{ocs4R::ocs4RLogger}} -> \code{ocsManager}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{apis}}{list of APIs}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ocsManager-new}{\code{ocsManager$new()}}
\item \href{#method-ocsManager-connect}{\code{ocsManager$connect()}}
\item \href{#method-ocsManager-getVersion}{\code{ocsManager$getVersion()}}
\item \href{#method-ocsManager-getCapabilities}{\code{ocsManager$getCapabilities()}}
\item \href{#method-ocsManager-getAPIWebdavManager}{\code{ocsManager$getAPIWebdavManager()}}
\item \href{#method-ocsManager-getAPISharingManager}{\code{ocsManager$getAPISharingManager()}}
\item \href{#method-ocsManager-getAPIUserProvisioningManager}{\code{ocsManager$getAPIUserProvisioningManager()}}
\item \href{#method-ocsManager-clone}{\code{ocsManager$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="ERROR"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-ERROR'><code>ocs4R::ocs4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="INFO"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-INFO'><code>ocs4R::ocs4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="WARN"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-WARN'><code>ocs4R::ocs4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="getClass"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-getClass'><code>ocs4R::ocs4RLogger$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="getClassName"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-getClassName'><code>ocs4R::ocs4RLogger$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ocs4R" data-topic="ocs4RLogger" data-id="logger"><a href='../../ocs4R/html/ocs4RLogger.html#method-ocs4RLogger-logger'><code>ocs4R::ocs4RLogger$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-new"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-new}{}}}
\subsection{Method \code{new()}}{
This method is used to instantiate an ocsManager. The user/pwd are
mandatory in order to connect to 'ocs'. The logger can be either NULL, "INFO" 
(with minimum logs), or "DEBUG" (for complete curl http calls logs).

The \code{keyring_backend} can be set to use a different backend for storing 
the user password with \pkg{keyring} (Default value is NULL, meaning the password 
is stored as private field).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$new(url, user, pwd, logger = NULL, keyring_backend = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{logger}}{logger type}

\item{\code{keyring_backend}}{keyring back-end. Default is \code{NULL}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-connect"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-connect}{}}}
\subsection{Method \code{connect()}}{
Method to connect to 'ocs' and set version/capabilities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$connect()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-getVersion"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-getVersion}{}}}
\subsection{Method \code{getVersion()}}{
Get the 'ocs' server version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$getVersion()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-getCapabilities"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-getCapabilities}{}}}
\subsection{Method \code{getCapabilities()}}{
Get the 'ocs' server capabilities
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$getCapabilities()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-getAPIWebdavManager"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-getAPIWebdavManager}{}}}
\subsection{Method \code{getAPIWebdavManager()}}{
Get the Webdav API manager
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$getAPIWebdavManager()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an instance of \link{ocsApiWebdavManager}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-getAPISharingManager"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-getAPISharingManager}{}}}
\subsection{Method \code{getAPISharingManager()}}{
Get the Sharing API manager
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$getAPISharingManager()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an instance of \link{ocsApiSharingManager}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-getAPIUserProvisioningManager"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-getAPIUserProvisioningManager}{}}}
\subsection{Method \code{getAPIUserProvisioningManager()}}{
Get the User Provisioning API manager
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$getAPIUserProvisioningManager()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
an instance of \link{ocsApiUserProvisioningManager}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ocsManager-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ocsManager-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ocsManager$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
